package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateIntegrationRequest(
    restApiId: String,
    resourceId: String,
    httpMethod: String,
    patchOperations: Option[Iterable[zio.aws.apigateway.model.PatchOperation]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateIntegrationRequest = {
    import UpdateIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateIntegrationRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .httpMethod(httpMethod: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateIntegrationRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateIntegrationRequest.wrap(buildAwsValue())
}
object UpdateIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateIntegrationRequest =
      zio.aws.apigateway.model.UpdateIntegrationRequest(
        restApiId,
        resourceId,
        httpMethod,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def restApiId: String
    def resourceId: String
    def httpMethod: String
    def patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getHttpMethod: ZIO[Any, Nothing, String] = ZIO.succeed(httpMethod)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateIntegrationRequest
  ) extends zio.aws.apigateway.model.UpdateIntegrationRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val httpMethod: String = impl.httpMethod(): String
    override val patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] = scala
      .Option(impl.patchOperations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.PatchOperation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateIntegrationRequest
  ): zio.aws.apigateway.model.UpdateIntegrationRequest.ReadOnly = new Wrapper(
    impl
  )
}
