package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableBoolean
import scala.jdk.CollectionConverters._
final case class Method(
    httpMethod: Option[String] = None,
    authorizationType: Option[String] = None,
    authorizerId: Option[String] = None,
    apiKeyRequired: Option[NullableBoolean] = None,
    requestValidatorId: Option[String] = None,
    operationName: Option[String] = None,
    requestParameters: Option[Map[String, NullableBoolean]] = None,
    requestModels: Option[Map[String, String]] = None,
    methodResponses: Option[
      Map[String, zio.aws.apigateway.model.MethodResponse]
    ] = None,
    methodIntegration: Option[zio.aws.apigateway.model.Integration] = None,
    authorizationScopes: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.Method = {
    import Method.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.Method
      .builder()
      .optionallyWith(httpMethod.map(value => value: java.lang.String))(
        _.httpMethod
      )
      .optionallyWith(authorizationType.map(value => value: java.lang.String))(
        _.authorizationType
      )
      .optionallyWith(authorizerId.map(value => value: java.lang.String))(
        _.authorizerId
      )
      .optionallyWith(apiKeyRequired.map(value => value: java.lang.Boolean))(
        _.apiKeyRequired
      )
      .optionallyWith(requestValidatorId.map(value => value: java.lang.String))(
        _.requestValidatorId
      )
      .optionallyWith(operationName.map(value => value: java.lang.String))(
        _.operationName
      )
      .optionallyWith(
        requestParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.Boolean)
            })
            .asJava
        )
      )(_.requestParameters)
      .optionallyWith(
        requestModels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestModels)
      .optionallyWith(
        methodResponses.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.methodResponses)
      .optionallyWith(methodIntegration.map(value => value.buildAwsValue()))(
        _.methodIntegration
      )
      .optionallyWith(
        authorizationScopes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.authorizationScopes)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.Method.ReadOnly =
    zio.aws.apigateway.model.Method.wrap(buildAwsValue())
}
object Method {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.apigateway.model.Method] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.Method =
      zio.aws.apigateway.model.Method(
        httpMethod.map(value => value),
        authorizationType.map(value => value),
        authorizerId.map(value => value),
        apiKeyRequired.map(value => value),
        requestValidatorId.map(value => value),
        operationName.map(value => value),
        requestParameters.map(value => value),
        requestModels.map(value => value),
        methodResponses.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        methodIntegration.map(value => value.asEditable),
        authorizationScopes.map(value => value)
      )
    def httpMethod: Option[String]
    def authorizationType: Option[String]
    def authorizerId: Option[String]
    def apiKeyRequired: Option[NullableBoolean]
    def requestValidatorId: Option[String]
    def operationName: Option[String]
    def requestParameters: Option[Map[String, NullableBoolean]]
    def requestModels: Option[Map[String, String]]
    def methodResponses
        : Option[Map[String, zio.aws.apigateway.model.MethodResponse.ReadOnly]]
    def methodIntegration: Option[zio.aws.apigateway.model.Integration.ReadOnly]
    def authorizationScopes: Option[List[String]]
    def getHttpMethod: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getAuthorizationType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizationType", authorizationType)
    def getAuthorizerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizerId", authorizerId)
    def getApiKeyRequired: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("apiKeyRequired", apiKeyRequired)
    def getRequestValidatorId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestValidatorId", requestValidatorId)
    def getOperationName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operationName", operationName)
    def getRequestParameters: ZIO[Any, AwsError, Map[String, NullableBoolean]] =
      AwsError.unwrapOptionField("requestParameters", requestParameters)
    def getRequestModels: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("requestModels", requestModels)
    def getMethodResponses: ZIO[Any, AwsError, Map[
      String,
      zio.aws.apigateway.model.MethodResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("methodResponses", methodResponses)
    def getMethodIntegration
        : ZIO[Any, AwsError, zio.aws.apigateway.model.Integration.ReadOnly] =
      AwsError.unwrapOptionField("methodIntegration", methodIntegration)
    def getAuthorizationScopes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("authorizationScopes", authorizationScopes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.Method
  ) extends zio.aws.apigateway.model.Method.ReadOnly {
    override val httpMethod: Option[String] =
      scala.Option(impl.httpMethod()).map(value => value: String)
    override val authorizationType: Option[String] =
      scala.Option(impl.authorizationType()).map(value => value: String)
    override val authorizerId: Option[String] =
      scala.Option(impl.authorizerId()).map(value => value: String)
    override val apiKeyRequired: Option[NullableBoolean] =
      scala.Option(impl.apiKeyRequired()).map(value => value: NullableBoolean)
    override val requestValidatorId: Option[String] =
      scala.Option(impl.requestValidatorId()).map(value => value: String)
    override val operationName: Option[String] =
      scala.Option(impl.operationName()).map(value => value: String)
    override val requestParameters: Option[Map[String, NullableBoolean]] = scala
      .Option(impl.requestParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: NullableBoolean)
          })
          .toMap
      )
    override val requestModels: Option[Map[String, String]] = scala
      .Option(impl.requestModels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val methodResponses: Option[
      Map[String, zio.aws.apigateway.model.MethodResponse.ReadOnly]
    ] = scala
      .Option(impl.methodResponses())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.apigateway.model.MethodResponse.wrap(value)
          })
          .toMap
      )
    override val methodIntegration
        : Option[zio.aws.apigateway.model.Integration.ReadOnly] = scala
      .Option(impl.methodIntegration())
      .map(value => zio.aws.apigateway.model.Integration.wrap(value))
    override val authorizationScopes: Option[List[String]] = scala
      .Option(impl.authorizationScopes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.Method
  ): zio.aws.apigateway.model.Method.ReadOnly = new Wrapper(impl)
}
