package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSdkRequest(
    restApiId: String,
    stageName: String,
    sdkType: String,
    parameters: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetSdkRequest = {
    import GetSdkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetSdkRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .stageName(stageName: java.lang.String)
      .sdkType(sdkType: java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetSdkRequest.ReadOnly =
    zio.aws.apigateway.model.GetSdkRequest.wrap(buildAwsValue())
}
object GetSdkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetSdkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetSdkRequest =
      zio.aws.apigateway.model.GetSdkRequest(
        restApiId,
        stageName,
        sdkType,
        parameters.map(value => value)
      )
    def restApiId: String
    def stageName: String
    def sdkType: String
    def parameters: Option[Map[String, String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getStageName: ZIO[Any, Nothing, String] = ZIO.succeed(stageName)
    def getSdkType: ZIO[Any, Nothing, String] = ZIO.succeed(sdkType)
    def getParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetSdkRequest
  ) extends zio.aws.apigateway.model.GetSdkRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val stageName: String = impl.stageName(): String
    override val sdkType: String = impl.sdkType(): String
    override val parameters: Option[Map[String, String]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetSdkRequest
  ): zio.aws.apigateway.model.GetSdkRequest.ReadOnly = new Wrapper(impl)
}
