package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableInteger
import scala.jdk.CollectionConverters._
final case class GetBasePathMappingsRequest(
    domainName: String,
    position: Option[String] = None,
    limit: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest = {
    import GetBasePathMappingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetBasePathMappingsRequest.ReadOnly =
    zio.aws.apigateway.model.GetBasePathMappingsRequest.wrap(buildAwsValue())
}
object GetBasePathMappingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetBasePathMappingsRequest =
      zio.aws.apigateway.model.GetBasePathMappingsRequest(
        domainName,
        position.map(value => value),
        limit.map(value => value)
      )
    def domainName: String
    def position: Option[String]
    def limit: Option[NullableInteger]
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest
  ) extends zio.aws.apigateway.model.GetBasePathMappingsRequest.ReadOnly {
    override val domainName: String = impl.domainName(): String
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val limit: Option[NullableInteger] =
      scala.Option(impl.limit()).map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsRequest
  ): zio.aws.apigateway.model.GetBasePathMappingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
