package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.apigateway.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class GetApiKeyResponse(
    id: Option[String] = None,
    value: Option[String] = None,
    name: Option[String] = None,
    customerId: Option[String] = None,
    description: Option[String] = None,
    enabled: Option[Boolean] = None,
    createdDate: Option[Timestamp] = None,
    lastUpdatedDate: Option[Timestamp] = None,
    stageKeys: Option[Iterable[String]] = None,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetApiKeyResponse = {
    import GetApiKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetApiKeyResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(customerId.map(value => value: java.lang.String))(
        _.customerId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        lastUpdatedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDate)
      .optionallyWith(
        stageKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.stageKeys)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetApiKeyResponse.ReadOnly =
    zio.aws.apigateway.model.GetApiKeyResponse.wrap(buildAwsValue())
}
object GetApiKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetApiKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetApiKeyResponse =
      zio.aws.apigateway.model.GetApiKeyResponse(
        id.map(value => value),
        value.map(value => value),
        name.map(value => value),
        customerId.map(value => value),
        description.map(value => value),
        enabled.map(value => value),
        createdDate.map(value => value),
        lastUpdatedDate.map(value => value),
        stageKeys.map(value => value),
        tags.map(value => value)
      )
    def id: Option[String]
    def value: Option[String]
    def name: Option[String]
    def customerId: Option[String]
    def description: Option[String]
    def enabled: Option[Boolean]
    def createdDate: Option[Timestamp]
    def lastUpdatedDate: Option[Timestamp]
    def stageKeys: Option[List[String]]
    def tags: Option[Map[String, String]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getCustomerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerId", customerId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getLastUpdatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
    def getStageKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("stageKeys", stageKeys)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetApiKeyResponse
  ) extends zio.aws.apigateway.model.GetApiKeyResponse.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val customerId: Option[String] =
      scala.Option(impl.customerId()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val createdDate: Option[Timestamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val lastUpdatedDate: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val stageKeys: Option[List[String]] = scala
      .Option(impl.stageKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetApiKeyResponse
  ): zio.aws.apigateway.model.GetApiKeyResponse.ReadOnly = new Wrapper(impl)
}
