package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAccountResponse(
    cloudwatchRoleArn: Option[String] = None,
    throttleSettings: Option[zio.aws.apigateway.model.ThrottleSettings] = None,
    features: Option[Iterable[String]] = None,
    apiKeyVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetAccountResponse = {
    import GetAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetAccountResponse
      .builder()
      .optionallyWith(cloudwatchRoleArn.map(value => value: java.lang.String))(
        _.cloudwatchRoleArn
      )
      .optionallyWith(throttleSettings.map(value => value.buildAwsValue()))(
        _.throttleSettings
      )
      .optionallyWith(
        features.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.features)
      .optionallyWith(apiKeyVersion.map(value => value: java.lang.String))(
        _.apiKeyVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetAccountResponse.ReadOnly =
    zio.aws.apigateway.model.GetAccountResponse.wrap(buildAwsValue())
}
object GetAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetAccountResponse =
      zio.aws.apigateway.model.GetAccountResponse(
        cloudwatchRoleArn.map(value => value),
        throttleSettings.map(value => value.asEditable),
        features.map(value => value),
        apiKeyVersion.map(value => value)
      )
    def cloudwatchRoleArn: Option[String]
    def throttleSettings
        : Option[zio.aws.apigateway.model.ThrottleSettings.ReadOnly]
    def features: Option[List[String]]
    def apiKeyVersion: Option[String]
    def getCloudwatchRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloudwatchRoleArn", cloudwatchRoleArn)
    def getThrottleSettings: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.ThrottleSettings.ReadOnly
    ] = AwsError.unwrapOptionField("throttleSettings", throttleSettings)
    def getFeatures: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("features", features)
    def getApiKeyVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("apiKeyVersion", apiKeyVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetAccountResponse
  ) extends zio.aws.apigateway.model.GetAccountResponse.ReadOnly {
    override val cloudwatchRoleArn: Option[String] =
      scala.Option(impl.cloudwatchRoleArn()).map(value => value: String)
    override val throttleSettings
        : Option[zio.aws.apigateway.model.ThrottleSettings.ReadOnly] = scala
      .Option(impl.throttleSettings())
      .map(value => zio.aws.apigateway.model.ThrottleSettings.wrap(value))
    override val features: Option[List[String]] = scala
      .Option(impl.features())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val apiKeyVersion: Option[String] =
      scala.Option(impl.apiKeyVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetAccountResponse
  ): zio.aws.apigateway.model.GetAccountResponse.ReadOnly = new Wrapper(impl)
}
