package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableInteger
import scala.jdk.CollectionConverters._
final case class CreateRestApiRequest(
    name: String,
    description: Option[String] = None,
    version: Option[String] = None,
    cloneFrom: Option[String] = None,
    binaryMediaTypes: Option[Iterable[String]] = None,
    minimumCompressionSize: Option[NullableInteger] = None,
    apiKeySource: Option[zio.aws.apigateway.model.ApiKeySourceType] = None,
    endpointConfiguration: Option[
      zio.aws.apigateway.model.EndpointConfiguration
    ] = None,
    policy: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    disableExecuteApiEndpoint: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest = {
    import CreateRestApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(cloneFrom.map(value => value: java.lang.String))(
        _.cloneFrom
      )
      .optionallyWith(
        binaryMediaTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.binaryMediaTypes)
      .optionallyWith(minimumCompressionSize.map(value => value: Integer))(
        _.minimumCompressionSize
      )
      .optionallyWith(apiKeySource.map(value => value.unwrap))(_.apiKeySource)
      .optionallyWith(
        endpointConfiguration.map(value => value.buildAwsValue())
      )(_.endpointConfiguration)
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        disableExecuteApiEndpoint.map(value => value: java.lang.Boolean)
      )(_.disableExecuteApiEndpoint)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateRestApiRequest.ReadOnly =
    zio.aws.apigateway.model.CreateRestApiRequest.wrap(buildAwsValue())
}
object CreateRestApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateRestApiRequest =
      zio.aws.apigateway.model.CreateRestApiRequest(
        name,
        description.map(value => value),
        version.map(value => value),
        cloneFrom.map(value => value),
        binaryMediaTypes.map(value => value),
        minimumCompressionSize.map(value => value),
        apiKeySource.map(value => value),
        endpointConfiguration.map(value => value.asEditable),
        policy.map(value => value),
        tags.map(value => value),
        disableExecuteApiEndpoint.map(value => value)
      )
    def name: String
    def description: Option[String]
    def version: Option[String]
    def cloneFrom: Option[String]
    def binaryMediaTypes: Option[List[String]]
    def minimumCompressionSize: Option[NullableInteger]
    def apiKeySource: Option[zio.aws.apigateway.model.ApiKeySourceType]
    def endpointConfiguration
        : Option[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly]
    def policy: Option[String]
    def tags: Option[Map[String, String]]
    def disableExecuteApiEndpoint: Option[Boolean]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getCloneFrom: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cloneFrom", cloneFrom)
    def getBinaryMediaTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("binaryMediaTypes", binaryMediaTypes)
    def getMinimumCompressionSize: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "minimumCompressionSize",
        minimumCompressionSize
      )
    def getApiKeySource
        : ZIO[Any, AwsError, zio.aws.apigateway.model.ApiKeySourceType] =
      AwsError.unwrapOptionField("apiKeySource", apiKeySource)
    def getEndpointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.EndpointConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("endpointConfiguration", endpointConfiguration)
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDisableExecuteApiEndpoint: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableExecuteApiEndpoint", disableExecuteApiEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest
  ) extends zio.aws.apigateway.model.CreateRestApiRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override val cloneFrom: Option[String] =
      scala.Option(impl.cloneFrom()).map(value => value: String)
    override val binaryMediaTypes: Option[List[String]] = scala
      .Option(impl.binaryMediaTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val minimumCompressionSize: Option[NullableInteger] = scala
      .Option(impl.minimumCompressionSize())
      .map(value => value: NullableInteger)
    override val apiKeySource
        : Option[zio.aws.apigateway.model.ApiKeySourceType] = scala
      .Option(impl.apiKeySource())
      .map(value => zio.aws.apigateway.model.ApiKeySourceType.wrap(value))
    override val endpointConfiguration
        : Option[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly] =
      scala
        .Option(impl.endpointConfiguration())
        .map(value =>
          zio.aws.apigateway.model.EndpointConfiguration.wrap(value)
        )
    override val policy: Option[String] =
      scala.Option(impl.policy()).map(value => value: String)
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val disableExecuteApiEndpoint: Option[Boolean] = scala
      .Option(impl.disableExecuteApiEndpoint())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateRestApiRequest
  ): zio.aws.apigateway.model.CreateRestApiRequest.ReadOnly = new Wrapper(impl)
}
