package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDomainNameRequest(
    domainName: String,
    certificateName: Option[String] = None,
    certificateBody: Option[String] = None,
    certificatePrivateKey: Option[String] = None,
    certificateChain: Option[String] = None,
    certificateArn: Option[String] = None,
    regionalCertificateName: Option[String] = None,
    regionalCertificateArn: Option[String] = None,
    endpointConfiguration: Option[
      zio.aws.apigateway.model.EndpointConfiguration
    ] = None,
    tags: Option[Map[String, String]] = None,
    securityPolicy: Option[zio.aws.apigateway.model.SecurityPolicy] = None,
    mutualTlsAuthentication: Option[
      zio.aws.apigateway.model.MutualTlsAuthenticationInput
    ] = None,
    ownershipVerificationCertificateArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest = {
    import CreateDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .optionallyWith(certificateName.map(value => value: java.lang.String))(
        _.certificateName
      )
      .optionallyWith(certificateBody.map(value => value: java.lang.String))(
        _.certificateBody
      )
      .optionallyWith(
        certificatePrivateKey.map(value => value: java.lang.String)
      )(_.certificatePrivateKey)
      .optionallyWith(certificateChain.map(value => value: java.lang.String))(
        _.certificateChain
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(
        regionalCertificateName.map(value => value: java.lang.String)
      )(_.regionalCertificateName)
      .optionallyWith(
        regionalCertificateArn.map(value => value: java.lang.String)
      )(_.regionalCertificateArn)
      .optionallyWith(
        endpointConfiguration.map(value => value.buildAwsValue())
      )(_.endpointConfiguration)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(securityPolicy.map(value => value.unwrap))(
        _.securityPolicy
      )
      .optionallyWith(
        mutualTlsAuthentication.map(value => value.buildAwsValue())
      )(_.mutualTlsAuthentication)
      .optionallyWith(
        ownershipVerificationCertificateArn.map(value =>
          value: java.lang.String
        )
      )(_.ownershipVerificationCertificateArn)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateDomainNameRequest.ReadOnly =
    zio.aws.apigateway.model.CreateDomainNameRequest.wrap(buildAwsValue())
}
object CreateDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateDomainNameRequest =
      zio.aws.apigateway.model.CreateDomainNameRequest(
        domainName,
        certificateName.map(value => value),
        certificateBody.map(value => value),
        certificatePrivateKey.map(value => value),
        certificateChain.map(value => value),
        certificateArn.map(value => value),
        regionalCertificateName.map(value => value),
        regionalCertificateArn.map(value => value),
        endpointConfiguration.map(value => value.asEditable),
        tags.map(value => value),
        securityPolicy.map(value => value),
        mutualTlsAuthentication.map(value => value.asEditable),
        ownershipVerificationCertificateArn.map(value => value)
      )
    def domainName: String
    def certificateName: Option[String]
    def certificateBody: Option[String]
    def certificatePrivateKey: Option[String]
    def certificateChain: Option[String]
    def certificateArn: Option[String]
    def regionalCertificateName: Option[String]
    def regionalCertificateArn: Option[String]
    def endpointConfiguration
        : Option[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly]
    def tags: Option[Map[String, String]]
    def securityPolicy: Option[zio.aws.apigateway.model.SecurityPolicy]
    def mutualTlsAuthentication
        : Option[zio.aws.apigateway.model.MutualTlsAuthenticationInput.ReadOnly]
    def ownershipVerificationCertificateArn: Option[String]
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getCertificateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getCertificateBody: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateBody", certificateBody)
    def getCertificatePrivateKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificatePrivateKey", certificatePrivateKey)
    def getCertificateChain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateChain", certificateChain)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getRegionalCertificateName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("regionalCertificateName", regionalCertificateName)
    def getRegionalCertificateArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("regionalCertificateArn", regionalCertificateArn)
    def getEndpointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.EndpointConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("endpointConfiguration", endpointConfiguration)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSecurityPolicy
        : ZIO[Any, AwsError, zio.aws.apigateway.model.SecurityPolicy] =
      AwsError.unwrapOptionField("securityPolicy", securityPolicy)
    def getMutualTlsAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.MutualTlsAuthenticationInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mutualTlsAuthentication",
      mutualTlsAuthentication
    )
    def getOwnershipVerificationCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "ownershipVerificationCertificateArn",
        ownershipVerificationCertificateArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest
  ) extends zio.aws.apigateway.model.CreateDomainNameRequest.ReadOnly {
    override val domainName: String = impl.domainName(): String
    override val certificateName: Option[String] =
      scala.Option(impl.certificateName()).map(value => value: String)
    override val certificateBody: Option[String] =
      scala.Option(impl.certificateBody()).map(value => value: String)
    override val certificatePrivateKey: Option[String] =
      scala.Option(impl.certificatePrivateKey()).map(value => value: String)
    override val certificateChain: Option[String] =
      scala.Option(impl.certificateChain()).map(value => value: String)
    override val certificateArn: Option[String] =
      scala.Option(impl.certificateArn()).map(value => value: String)
    override val regionalCertificateName: Option[String] =
      scala.Option(impl.regionalCertificateName()).map(value => value: String)
    override val regionalCertificateArn: Option[String] =
      scala.Option(impl.regionalCertificateArn()).map(value => value: String)
    override val endpointConfiguration
        : Option[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly] =
      scala
        .Option(impl.endpointConfiguration())
        .map(value =>
          zio.aws.apigateway.model.EndpointConfiguration.wrap(value)
        )
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val securityPolicy
        : Option[zio.aws.apigateway.model.SecurityPolicy] = scala
      .Option(impl.securityPolicy())
      .map(value => zio.aws.apigateway.model.SecurityPolicy.wrap(value))
    override val mutualTlsAuthentication: Option[
      zio.aws.apigateway.model.MutualTlsAuthenticationInput.ReadOnly
    ] = scala
      .Option(impl.mutualTlsAuthentication())
      .map(value =>
        zio.aws.apigateway.model.MutualTlsAuthenticationInput.wrap(value)
      )
    override val ownershipVerificationCertificateArn: Option[String] = scala
      .Option(impl.ownershipVerificationCertificateArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest
  ): zio.aws.apigateway.model.CreateDomainNameRequest.ReadOnly = new Wrapper(
    impl
  )
}
