package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDocumentationVersionRequest(
    restApiId: String,
    documentationVersion: String,
    stageName: Option[String] = None,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionRequest = {
    import CreateDocumentationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .documentationVersion(documentationVersion: java.lang.String)
      .optionallyWith(stageName.map(value => value: java.lang.String))(
        _.stageName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.CreateDocumentationVersionRequest.ReadOnly =
    zio.aws.apigateway.model.CreateDocumentationVersionRequest
      .wrap(buildAwsValue())
}
object CreateDocumentationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateDocumentationVersionRequest =
      zio.aws.apigateway.model.CreateDocumentationVersionRequest(
        restApiId,
        documentationVersion,
        stageName.map(value => value),
        description.map(value => value)
      )
    def restApiId: String
    def documentationVersion: String
    def stageName: Option[String]
    def description: Option[String]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getDocumentationVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(documentationVersion)
    def getStageName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionRequest
  ) extends zio.aws.apigateway.model.CreateDocumentationVersionRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val documentationVersion: String =
      impl.documentationVersion(): String
    override val stageName: Option[String] =
      scala.Option(impl.stageName()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateDocumentationVersionRequest
  ): zio.aws.apigateway.model.CreateDocumentationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
