package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.{NullableInteger, ProviderARN}
import scala.jdk.CollectionConverters._
final case class CreateAuthorizerRequest(
    restApiId: String,
    name: String,
    `type`: zio.aws.apigateway.model.AuthorizerType,
    providerARNs: Option[Iterable[ProviderARN]] = None,
    authType: Option[String] = None,
    authorizerUri: Option[String] = None,
    authorizerCredentials: Option[String] = None,
    identitySource: Option[String] = None,
    identityValidationExpression: Option[String] = None,
    authorizerResultTtlInSeconds: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest = {
    import CreateAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .name(name: java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        providerARNs.map(value =>
          value.map { item =>
            ProviderARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.providerARNs)
      .optionallyWith(authType.map(value => value: java.lang.String))(
        _.authType
      )
      .optionallyWith(authorizerUri.map(value => value: java.lang.String))(
        _.authorizerUri
      )
      .optionallyWith(
        authorizerCredentials.map(value => value: java.lang.String)
      )(_.authorizerCredentials)
      .optionallyWith(identitySource.map(value => value: java.lang.String))(
        _.identitySource
      )
      .optionallyWith(
        identityValidationExpression.map(value => value: java.lang.String)
      )(_.identityValidationExpression)
      .optionallyWith(
        authorizerResultTtlInSeconds.map(value => value: Integer)
      )(_.authorizerResultTtlInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateAuthorizerRequest.ReadOnly =
    zio.aws.apigateway.model.CreateAuthorizerRequest.wrap(buildAwsValue())
}
object CreateAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateAuthorizerRequest =
      zio.aws.apigateway.model.CreateAuthorizerRequest(
        restApiId,
        name,
        `type`,
        providerARNs.map(value => value),
        authType.map(value => value),
        authorizerUri.map(value => value),
        authorizerCredentials.map(value => value),
        identitySource.map(value => value),
        identityValidationExpression.map(value => value),
        authorizerResultTtlInSeconds.map(value => value)
      )
    def restApiId: String
    def name: String
    def `type`: zio.aws.apigateway.model.AuthorizerType
    def providerARNs: Option[List[ProviderARN]]
    def authType: Option[String]
    def authorizerUri: Option[String]
    def authorizerCredentials: Option[String]
    def identitySource: Option[String]
    def identityValidationExpression: Option[String]
    def authorizerResultTtlInSeconds: Option[NullableInteger]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.apigateway.model.AuthorizerType] =
      ZIO.succeed(`type`)
    def getProviderARNs: ZIO[Any, AwsError, List[ProviderARN]] =
      AwsError.unwrapOptionField("providerARNs", providerARNs)
    def getAuthType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authType", authType)
    def getAuthorizerUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizerUri", authorizerUri)
    def getAuthorizerCredentials: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizerCredentials", authorizerCredentials)
    def getIdentitySource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identitySource", identitySource)
    def getIdentityValidationExpression: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "identityValidationExpression",
        identityValidationExpression
      )
    def getAuthorizerResultTtlInSeconds: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "authorizerResultTtlInSeconds",
        authorizerResultTtlInSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest
  ) extends zio.aws.apigateway.model.CreateAuthorizerRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val name: String = impl.name(): String
    override val `type`: zio.aws.apigateway.model.AuthorizerType =
      zio.aws.apigateway.model.AuthorizerType.wrap(impl.`type`())
    override val providerARNs: Option[List[ProviderARN]] = scala
      .Option(impl.providerARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.primitives.ProviderARN(item)
        }.toList
      )
    override val authType: Option[String] =
      scala.Option(impl.authType()).map(value => value: String)
    override val authorizerUri: Option[String] =
      scala.Option(impl.authorizerUri()).map(value => value: String)
    override val authorizerCredentials: Option[String] =
      scala.Option(impl.authorizerCredentials()).map(value => value: String)
    override val identitySource: Option[String] =
      scala.Option(impl.identitySource()).map(value => value: String)
    override val identityValidationExpression: Option[String] = scala
      .Option(impl.identityValidationExpression())
      .map(value => value: String)
    override val authorizerResultTtlInSeconds: Option[NullableInteger] = scala
      .Option(impl.authorizerResultTtlInSeconds())
      .map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest
  ): zio.aws.apigateway.model.CreateAuthorizerRequest.ReadOnly = new Wrapper(
    impl
  )
}
