package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SdkConfigurationProperty(
    name: Option[String] = None,
    friendlyName: Option[String] = None,
    description: Option[String] = None,
    required: Option[Boolean] = None,
    defaultValue: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.SdkConfigurationProperty = {
    import SdkConfigurationProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.SdkConfigurationProperty
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(friendlyName.map(value => value: java.lang.String))(
        _.friendlyName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(required.map(value => value: java.lang.Boolean))(
        _.required
      )
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.SdkConfigurationProperty.ReadOnly =
    zio.aws.apigateway.model.SdkConfigurationProperty.wrap(buildAwsValue())
}
object SdkConfigurationProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.SdkConfigurationProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.SdkConfigurationProperty =
      zio.aws.apigateway.model.SdkConfigurationProperty(
        name.map(value => value),
        friendlyName.map(value => value),
        description.map(value => value),
        required.map(value => value),
        defaultValue.map(value => value)
      )
    def name: Option[String]
    def friendlyName: Option[String]
    def description: Option[String]
    def required: Option[Boolean]
    def defaultValue: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getFriendlyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("friendlyName", friendlyName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("required", required)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.SdkConfigurationProperty
  ) extends zio.aws.apigateway.model.SdkConfigurationProperty.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val friendlyName: Option[String] =
      scala.Option(impl.friendlyName()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val required: Option[Boolean] =
      scala.Option(impl.required()).map(value => value: Boolean)
    override val defaultValue: Option[String] =
      scala.Option(impl.defaultValue()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.SdkConfigurationProperty
  ): zio.aws.apigateway.model.SdkConfigurationProperty.ReadOnly = new Wrapper(
    impl
  )
}
