package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MutualTlsAuthentication(
    truststoreUri: Option[String] = None,
    truststoreVersion: Option[String] = None,
    truststoreWarnings: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.MutualTlsAuthentication = {
    import MutualTlsAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.MutualTlsAuthentication
      .builder()
      .optionallyWith(truststoreUri.map(value => value: java.lang.String))(
        _.truststoreUri
      )
      .optionallyWith(truststoreVersion.map(value => value: java.lang.String))(
        _.truststoreVersion
      )
      .optionallyWith(
        truststoreWarnings.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.truststoreWarnings)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.MutualTlsAuthentication.ReadOnly =
    zio.aws.apigateway.model.MutualTlsAuthentication.wrap(buildAwsValue())
}
object MutualTlsAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.MutualTlsAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.MutualTlsAuthentication =
      zio.aws.apigateway.model.MutualTlsAuthentication(
        truststoreUri.map(value => value),
        truststoreVersion.map(value => value),
        truststoreWarnings.map(value => value)
      )
    def truststoreUri: Option[String]
    def truststoreVersion: Option[String]
    def truststoreWarnings: Option[List[String]]
    def getTruststoreUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("truststoreUri", truststoreUri)
    def getTruststoreVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("truststoreVersion", truststoreVersion)
    def getTruststoreWarnings: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("truststoreWarnings", truststoreWarnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.MutualTlsAuthentication
  ) extends zio.aws.apigateway.model.MutualTlsAuthentication.ReadOnly {
    override val truststoreUri: Option[String] =
      scala.Option(impl.truststoreUri()).map(value => value: String)
    override val truststoreVersion: Option[String] =
      scala.Option(impl.truststoreVersion()).map(value => value: String)
    override val truststoreWarnings: Option[List[String]] = scala
      .Option(impl.truststoreWarnings())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.MutualTlsAuthentication
  ): zio.aws.apigateway.model.MutualTlsAuthentication.ReadOnly = new Wrapper(
    impl
  )
}
