package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableInteger
import scala.jdk.CollectionConverters._
final case class GetGatewayResponsesRequest(
    restApiId: String,
    position: Option[String] = None,
    limit: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesRequest = {
    import GetGatewayResponsesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(limit.map(value => value: Integer))(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetGatewayResponsesRequest.ReadOnly =
    zio.aws.apigateway.model.GetGatewayResponsesRequest.wrap(buildAwsValue())
}
object GetGatewayResponsesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetGatewayResponsesRequest =
      zio.aws.apigateway.model.GetGatewayResponsesRequest(
        restApiId,
        position.map(value => value),
        limit.map(value => value)
      )
    def restApiId: String
    def position: Option[String]
    def limit: Option[NullableInteger]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesRequest
  ) extends zio.aws.apigateway.model.GetGatewayResponsesRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val limit: Option[NullableInteger] =
      scala.Option(impl.limit()).map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetGatewayResponsesRequest
  ): zio.aws.apigateway.model.GetGatewayResponsesRequest.ReadOnly = new Wrapper(
    impl
  )
}
