package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BasePathMapping(
    basePath: Option[String] = None,
    restApiId: Option[String] = None,
    stage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.BasePathMapping = {
    import BasePathMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.BasePathMapping
      .builder()
      .optionallyWith(basePath.map(value => value: java.lang.String))(
        _.basePath
      )
      .optionallyWith(restApiId.map(value => value: java.lang.String))(
        _.restApiId
      )
      .optionallyWith(stage.map(value => value: java.lang.String))(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.BasePathMapping.ReadOnly =
    zio.aws.apigateway.model.BasePathMapping.wrap(buildAwsValue())
}
object BasePathMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.BasePathMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.BasePathMapping =
      zio.aws.apigateway.model.BasePathMapping(
        basePath.map(value => value),
        restApiId.map(value => value),
        stage.map(value => value)
      )
    def basePath: Option[String]
    def restApiId: Option[String]
    def stage: Option[String]
    def getBasePath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("basePath", basePath)
    def getRestApiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restApiId", restApiId)
    def getStage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.BasePathMapping
  ) extends zio.aws.apigateway.model.BasePathMapping.ReadOnly {
    override val basePath: Option[String] =
      scala.Option(impl.basePath()).map(value => value: String)
    override val restApiId: Option[String] =
      scala.Option(impl.restApiId()).map(value => value: String)
    override val stage: Option[String] =
      scala.Option(impl.stage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.BasePathMapping
  ): zio.aws.apigateway.model.BasePathMapping.ReadOnly = new Wrapper(impl)
}
