package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.{NullableBoolean, StatusCode}
import scala.jdk.CollectionConverters._
final case class GetMethodResponseResponse(
    statusCode: Option[StatusCode] = None,
    responseParameters: Option[Map[String, NullableBoolean]] = None,
    responseModels: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetMethodResponseResponse = {
    import GetMethodResponseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetMethodResponseResponse
      .builder()
      .optionallyWith(
        statusCode.map(value => StatusCode.unwrap(value): java.lang.String)
      )(_.statusCode)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.Boolean)
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        responseModels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseModels)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetMethodResponseResponse.ReadOnly =
    zio.aws.apigateway.model.GetMethodResponseResponse.wrap(buildAwsValue())
}
object GetMethodResponseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetMethodResponseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetMethodResponseResponse =
      zio.aws.apigateway.model.GetMethodResponseResponse(
        statusCode.map(value => value),
        responseParameters.map(value => value),
        responseModels.map(value => value)
      )
    def statusCode: Option[StatusCode]
    def responseParameters: Option[Map[String, NullableBoolean]]
    def responseModels: Option[Map[String, String]]
    def getStatusCode: ZIO[Any, AwsError, StatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getResponseParameters
        : ZIO[Any, AwsError, Map[String, NullableBoolean]] =
      AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getResponseModels: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseModels", responseModels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetMethodResponseResponse
  ) extends zio.aws.apigateway.model.GetMethodResponseResponse.ReadOnly {
    override val statusCode: Option[StatusCode] = scala
      .Option(impl.statusCode())
      .map(value => zio.aws.apigateway.model.primitives.StatusCode(value))
    override val responseParameters: Option[Map[String, NullableBoolean]] =
      scala
        .Option(impl.responseParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: NullableBoolean)
            })
            .toMap
        )
    override val responseModels: Option[Map[String, String]] = scala
      .Option(impl.responseModels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetMethodResponseResponse
  ): zio.aws.apigateway.model.GetMethodResponseResponse.ReadOnly = new Wrapper(
    impl
  )
}
