package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableInteger
import scala.jdk.CollectionConverters._
final case class GetUsagePlanKeysRequest(
    usagePlanId: String,
    position: Option[String] = None,
    limit: Option[NullableInteger] = None,
    nameQuery: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest = {
    import GetUsagePlanKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest
      .builder()
      .usagePlanId(usagePlanId: java.lang.String)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        limit.map(value => NullableInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(nameQuery.map(value => value: java.lang.String))(
        _.nameQuery
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetUsagePlanKeysRequest.ReadOnly =
    zio.aws.apigateway.model.GetUsagePlanKeysRequest.wrap(buildAwsValue())
}
object GetUsagePlanKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetUsagePlanKeysRequest =
      zio.aws.apigateway.model.GetUsagePlanKeysRequest(
        usagePlanId,
        position.map(value => value),
        limit.map(value => value),
        nameQuery.map(value => value)
      )
    def usagePlanId: String
    def position: Option[String]
    def limit: Option[NullableInteger]
    def nameQuery: Option[String]
    def getUsagePlanId: ZIO[Any, Nothing, String] = ZIO.succeed(usagePlanId)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNameQuery: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nameQuery", nameQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest
  ) extends zio.aws.apigateway.model.GetUsagePlanKeysRequest.ReadOnly {
    override val usagePlanId: String = impl.usagePlanId(): String
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val limit: Option[NullableInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.apigateway.model.primitives.NullableInteger(value))
    override val nameQuery: Option[String] =
      scala.Option(impl.nameQuery()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlanKeysRequest
  ): zio.aws.apigateway.model.GetUsagePlanKeysRequest.ReadOnly = new Wrapper(
    impl
  )
}
