package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GenerateClientCertificateRequest(
    description: Option[String] = None,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateRequest = {
    import GenerateClientCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.GenerateClientCertificateRequest.ReadOnly =
    zio.aws.apigateway.model.GenerateClientCertificateRequest
      .wrap(buildAwsValue())
}
object GenerateClientCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GenerateClientCertificateRequest =
      zio.aws.apigateway.model.GenerateClientCertificateRequest(
        description.map(value => value),
        tags.map(value => value)
      )
    def description: Option[String]
    def tags: Option[Map[String, String]]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateRequest
  ) extends zio.aws.apigateway.model.GenerateClientCertificateRequest.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GenerateClientCertificateRequest
  ): zio.aws.apigateway.model.GenerateClientCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
