package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.apigateway.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class Deployment(
    id: Option[String] = None,
    description: Option[String] = None,
    createdDate: Option[Timestamp] = None,
    apiSummary: Option[
      Map[String, Map[String, zio.aws.apigateway.model.MethodSnapshot]]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.Deployment = {
    import Deployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.Deployment
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        apiSummary.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> value.buildAwsValue()
                })
                .asJava
            })
            .asJava
        )
      )(_.apiSummary)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.Deployment.ReadOnly =
    zio.aws.apigateway.model.Deployment.wrap(buildAwsValue())
}
object Deployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.Deployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.Deployment =
      zio.aws.apigateway.model.Deployment(
        id.map(value => value),
        description.map(value => value),
        createdDate.map(value => value),
        apiSummary.map(value =>
          value.map({ case (key, value) =>
            key -> value.map({ case (key, value) =>
              key -> value.asEditable
            })
          })
        )
      )
    def id: Option[String]
    def description: Option[String]
    def createdDate: Option[Timestamp]
    def apiSummary: Option[
      Map[String, Map[String, zio.aws.apigateway.model.MethodSnapshot.ReadOnly]]
    ]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getApiSummary: ZIO[Any, AwsError, Map[
      String,
      Map[String, zio.aws.apigateway.model.MethodSnapshot.ReadOnly]
    ]] = AwsError.unwrapOptionField("apiSummary", apiSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.Deployment
  ) extends zio.aws.apigateway.model.Deployment.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val createdDate: Option[Timestamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val apiSummary: Option[
      Map[String, Map[String, zio.aws.apigateway.model.MethodSnapshot.ReadOnly]]
    ] = scala
      .Option(impl.apiSummary())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> value.asScala
              .map({ case (key, value) =>
                (key: String) -> zio.aws.apigateway.model.MethodSnapshot
                  .wrap(value)
              })
              .toMap
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.Deployment
  ): zio.aws.apigateway.model.Deployment.ReadOnly = new Wrapper(impl)
}
