package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApiStage(
    apiId: Option[String] = None,
    stage: Option[String] = None,
    throttle: Option[Map[String, zio.aws.apigateway.model.ThrottleSettings]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.ApiStage = {
    import ApiStage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.ApiStage
      .builder()
      .optionallyWith(apiId.map(value => value: java.lang.String))(_.apiId)
      .optionallyWith(stage.map(value => value: java.lang.String))(_.stage)
      .optionallyWith(
        throttle.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.throttle)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.ApiStage.ReadOnly =
    zio.aws.apigateway.model.ApiStage.wrap(buildAwsValue())
}
object ApiStage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.ApiStage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.ApiStage =
      zio.aws.apigateway.model.ApiStage(
        apiId.map(value => value),
        stage.map(value => value),
        throttle.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def apiId: Option[String]
    def stage: Option[String]
    def throttle: Option[
      Map[String, zio.aws.apigateway.model.ThrottleSettings.ReadOnly]
    ]
    def getApiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("apiId", apiId)
    def getStage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stage", stage)
    def getThrottle: ZIO[Any, AwsError, Map[
      String,
      zio.aws.apigateway.model.ThrottleSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("throttle", throttle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.ApiStage
  ) extends zio.aws.apigateway.model.ApiStage.ReadOnly {
    override val apiId: Option[String] =
      scala.Option(impl.apiId()).map(value => value: String)
    override val stage: Option[String] =
      scala.Option(impl.stage()).map(value => value: String)
    override val throttle: Option[
      Map[String, zio.aws.apigateway.model.ThrottleSettings.ReadOnly]
    ] = scala
      .Option(impl.throttle())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.apigateway.model.ThrottleSettings
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.ApiStage
  ): zio.aws.apigateway.model.ApiStage.ReadOnly = new Wrapper(impl)
}
