package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class TestInvokeMethodResponse(
    status: Option[Integer] = None,
    body: Option[String] = None,
    headers: Option[Map[String, String]] = None,
    multiValueHeaders: Option[Map[String, Iterable[String]]] = None,
    log: Option[String] = None,
    latency: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse = {
    import TestInvokeMethodResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse
      .builder()
      .optionallyWith(
        status.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.status)
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        headers.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.headers)
      .optionallyWith(
        multiValueHeaders.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.multiValueHeaders)
      .optionallyWith(log.map(value => value: java.lang.String))(_.log)
      .optionallyWith(latency.map(value => value: java.lang.Long))(_.latency)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.TestInvokeMethodResponse.ReadOnly =
    zio.aws.apigateway.model.TestInvokeMethodResponse.wrap(buildAwsValue())
}
object TestInvokeMethodResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.TestInvokeMethodResponse =
      zio.aws.apigateway.model.TestInvokeMethodResponse(
        status.map(value => value),
        body.map(value => value),
        headers.map(value => value),
        multiValueHeaders.map(value => value),
        log.map(value => value),
        latency.map(value => value)
      )
    def status: Option[Integer]
    def body: Option[String]
    def headers: Option[Map[String, String]]
    def multiValueHeaders: Option[Map[String, List[String]]]
    def log: Option[String]
    def latency: Option[Long]
    def getStatus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("status", status)
    def getBody: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("body", body)
    def getHeaders: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("headers", headers)
    def getMultiValueHeaders: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("multiValueHeaders", multiValueHeaders)
    def getLog: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("log", log)
    def getLatency: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("latency", latency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse
  ) extends zio.aws.apigateway.model.TestInvokeMethodResponse.ReadOnly {
    override val status: Option[Integer] = scala
      .Option(impl.status())
      .map(value => zio.aws.apigateway.model.primitives.Integer(value))
    override val body: Option[String] =
      scala.Option(impl.body()).map(value => value: String)
    override val headers: Option[Map[String, String]] = scala
      .Option(impl.headers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val multiValueHeaders: Option[Map[String, List[String]]] = scala
      .Option(impl.multiValueHeaders())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> value.asScala.map { item =>
              item: String
            }.toList
          })
          .toMap
      )
    override val log: Option[String] =
      scala.Option(impl.log()).map(value => value: String)
    override val latency: Option[Long] =
      scala.Option(impl.latency()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeMethodResponse
  ): zio.aws.apigateway.model.TestInvokeMethodResponse.ReadOnly = new Wrapper(
    impl
  )
}
