package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PatchOperation(
    op: Option[zio.aws.apigateway.model.Op] = None,
    path: Option[String] = None,
    value: Option[String] = None,
    from: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.PatchOperation = {
    import PatchOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.PatchOperation
      .builder()
      .optionallyWith(op.map(value => value.unwrap))(_.op)
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(from.map(value => value: java.lang.String))(_.from)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.PatchOperation.ReadOnly =
    zio.aws.apigateway.model.PatchOperation.wrap(buildAwsValue())
}
object PatchOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.PatchOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.PatchOperation =
      zio.aws.apigateway.model.PatchOperation(
        op.map(value => value),
        path.map(value => value),
        value.map(value => value),
        from.map(value => value)
      )
    def op: Option[zio.aws.apigateway.model.Op]
    def path: Option[String]
    def value: Option[String]
    def from: Option[String]
    def getOp: ZIO[Any, AwsError, zio.aws.apigateway.model.Op] =
      AwsError.unwrapOptionField("op", op)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getFrom: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("from", from)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.PatchOperation
  ) extends zio.aws.apigateway.model.PatchOperation.ReadOnly {
    override val op: Option[zio.aws.apigateway.model.Op] = scala
      .Option(impl.op())
      .map(value => zio.aws.apigateway.model.Op.wrap(value))
    override val path: Option[String] =
      scala.Option(impl.path()).map(value => value: String)
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
    override val from: Option[String] =
      scala.Option(impl.from()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.PatchOperation
  ): zio.aws.apigateway.model.PatchOperation.ReadOnly = new Wrapper(impl)
}
