package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTagsResponse(tags: Option[Map[String, String]] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetTagsResponse = {
    import GetTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetTagsResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetTagsResponse.ReadOnly =
    zio.aws.apigateway.model.GetTagsResponse.wrap(buildAwsValue())
}
object GetTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetTagsResponse =
      zio.aws.apigateway.model.GetTagsResponse(tags.map(value => value))
    def tags: Option[Map[String, String]]
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetTagsResponse
  ) extends zio.aws.apigateway.model.GetTagsResponse.ReadOnly {
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetTagsResponse
  ): zio.aws.apigateway.model.GetTagsResponse.ReadOnly = new Wrapper(impl)
}
