package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.StatusCode
import scala.jdk.CollectionConverters._
final case class PutGatewayResponseRequest(
    restApiId: String,
    responseType: zio.aws.apigateway.model.GatewayResponseType,
    statusCode: Option[StatusCode] = None,
    responseParameters: Option[Map[String, String]] = None,
    responseTemplates: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest = {
    import PutGatewayResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .responseType(responseType.unwrap)
      .optionallyWith(
        statusCode.map(value => StatusCode.unwrap(value): java.lang.String)
      )(_.statusCode)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        responseTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseTemplates)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.PutGatewayResponseRequest.ReadOnly =
    zio.aws.apigateway.model.PutGatewayResponseRequest.wrap(buildAwsValue())
}
object PutGatewayResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.PutGatewayResponseRequest =
      zio.aws.apigateway.model.PutGatewayResponseRequest(
        restApiId,
        responseType,
        statusCode.map(value => value),
        responseParameters.map(value => value),
        responseTemplates.map(value => value)
      )
    def restApiId: String
    def responseType: zio.aws.apigateway.model.GatewayResponseType
    def statusCode: Option[StatusCode]
    def responseParameters: Option[Map[String, String]]
    def responseTemplates: Option[Map[String, String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResponseType
        : ZIO[Any, Nothing, zio.aws.apigateway.model.GatewayResponseType] =
      ZIO.succeed(responseType)
    def getStatusCode: ZIO[Any, AwsError, StatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getResponseParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getResponseTemplates: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseTemplates", responseTemplates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest
  ) extends zio.aws.apigateway.model.PutGatewayResponseRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val responseType: zio.aws.apigateway.model.GatewayResponseType =
      zio.aws.apigateway.model.GatewayResponseType.wrap(impl.responseType())
    override val statusCode: Option[StatusCode] = scala
      .Option(impl.statusCode())
      .map(value => zio.aws.apigateway.model.primitives.StatusCode(value))
    override val responseParameters: Option[Map[String, String]] = scala
      .Option(impl.responseParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val responseTemplates: Option[Map[String, String]] = scala
      .Option(impl.responseTemplates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest
  ): zio.aws.apigateway.model.PutGatewayResponseRequest.ReadOnly = new Wrapper(
    impl
  )
}
