package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableInteger
import scala.jdk.CollectionConverters._
final case class GetUsagePlansRequest(
    position: Option[String] = None,
    keyId: Option[String] = None,
    limit: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest = {
    import GetUsagePlansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(keyId.map(value => value: java.lang.String))(_.keyId)
      .optionallyWith(
        limit.map(value => NullableInteger.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetUsagePlansRequest.ReadOnly =
    zio.aws.apigateway.model.GetUsagePlansRequest.wrap(buildAwsValue())
}
object GetUsagePlansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetUsagePlansRequest =
      zio.aws.apigateway.model.GetUsagePlansRequest(
        position.map(value => value),
        keyId.map(value => value),
        limit.map(value => value)
      )
    def position: Option[String]
    def keyId: Option[String]
    def limit: Option[NullableInteger]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest
  ) extends zio.aws.apigateway.model.GetUsagePlansRequest.ReadOnly {
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val keyId: Option[String] =
      scala.Option(impl.keyId()).map(value => value: String)
    override val limit: Option[NullableInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.apigateway.model.primitives.NullableInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlansRequest
  ): zio.aws.apigateway.model.GetUsagePlansRequest.ReadOnly = new Wrapper(impl)
}
