package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStageRequest(restApiId: String, stageName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetStageRequest = {
    import GetStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetStageRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .stageName(stageName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetStageRequest.ReadOnly =
    zio.aws.apigateway.model.GetStageRequest.wrap(buildAwsValue())
}
object GetStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetStageRequest =
      zio.aws.apigateway.model.GetStageRequest(restApiId, stageName)
    def restApiId: String
    def stageName: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getStageName: ZIO[Any, Nothing, String] = ZIO.succeed(stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetStageRequest
  ) extends zio.aws.apigateway.model.GetStageRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val stageName: String = impl.stageName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetStageRequest
  ): zio.aws.apigateway.model.GetStageRequest.ReadOnly = new Wrapper(impl)
}
