package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableInteger
import scala.jdk.CollectionConverters._
final case class GetResourcesRequest(
    restApiId: String,
    position: Option[String] = None,
    limit: Option[NullableInteger] = None,
    embed: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetResourcesRequest = {
    import GetResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetResourcesRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        limit.map(value => NullableInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        embed.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.embed)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetResourcesRequest.ReadOnly =
    zio.aws.apigateway.model.GetResourcesRequest.wrap(buildAwsValue())
}
object GetResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetResourcesRequest =
      zio.aws.apigateway.model.GetResourcesRequest(
        restApiId,
        position.map(value => value),
        limit.map(value => value),
        embed.map(value => value)
      )
    def restApiId: String
    def position: Option[String]
    def limit: Option[NullableInteger]
    def embed: Option[List[String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getEmbed: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("embed", embed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetResourcesRequest
  ) extends zio.aws.apigateway.model.GetResourcesRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val limit: Option[NullableInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.apigateway.model.primitives.NullableInteger(value))
    override val embed: Option[List[String]] = scala
      .Option(impl.embed())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetResourcesRequest
  ): zio.aws.apigateway.model.GetResourcesRequest.ReadOnly = new Wrapper(impl)
}
