package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateUsageResponse(
    usagePlanId: Option[String] = None,
    startDate: Option[String] = None,
    endDate: Option[String] = None,
    position: Option[String] = None,
    items: Option[Map[String, Iterable[Iterable[Long]]]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse = {
    import UpdateUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse
      .builder()
      .optionallyWith(usagePlanId.map(value => value: java.lang.String))(
        _.usagePlanId
      )
      .optionallyWith(startDate.map(value => value: java.lang.String))(
        _.startDate
      )
      .optionallyWith(endDate.map(value => value: java.lang.String))(_.endDate)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item.map { item =>
                  item: java.lang.Long
                }.asJavaCollection
              }.asJavaCollection
            })
            .asJava
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateUsageResponse.ReadOnly =
    zio.aws.apigateway.model.UpdateUsageResponse.wrap(buildAwsValue())
}
object UpdateUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateUsageResponse =
      zio.aws.apigateway.model.UpdateUsageResponse(
        usagePlanId.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        position.map(value => value),
        items.map(value => value)
      )
    def usagePlanId: Option[String]
    def startDate: Option[String]
    def endDate: Option[String]
    def position: Option[String]
    def items: Option[Map[String, List[List[Long]]]]
    def getUsagePlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usagePlanId", usagePlanId)
    def getStartDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems: ZIO[Any, AwsError, Map[String, List[List[Long]]]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse
  ) extends zio.aws.apigateway.model.UpdateUsageResponse.ReadOnly {
    override val usagePlanId: Option[String] =
      scala.Option(impl.usagePlanId()).map(value => value: String)
    override val startDate: Option[String] =
      scala.Option(impl.startDate()).map(value => value: String)
    override val endDate: Option[String] =
      scala.Option(impl.endDate()).map(value => value: String)
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val items: Option[Map[String, List[List[Long]]]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> value.asScala.map { item =>
              item.asScala.map { item =>
                item: Long
              }.toList
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse
  ): zio.aws.apigateway.model.UpdateUsageResponse.ReadOnly = new Wrapper(impl)
}
