package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateStageRequest(
    restApiId: String,
    stageName: String,
    patchOperations: Option[Iterable[zio.aws.apigateway.model.PatchOperation]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateStageRequest = {
    import UpdateStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateStageRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .stageName(stageName: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateStageRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateStageRequest.wrap(buildAwsValue())
}
object UpdateStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateStageRequest =
      zio.aws.apigateway.model.UpdateStageRequest(
        restApiId,
        stageName,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def restApiId: String
    def stageName: String
    def patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getStageName: ZIO[Any, Nothing, String] = ZIO.succeed(stageName)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateStageRequest
  ) extends zio.aws.apigateway.model.UpdateStageRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val stageName: String = impl.stageName(): String
    override val patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] = scala
      .Option(impl.patchOperations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.PatchOperation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateStageRequest
  ): zio.aws.apigateway.model.UpdateStageRequest.ReadOnly = new Wrapper(impl)
}
