package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDocumentationPartRequest(
    restApiId: String,
    documentationPartId: String,
    patchOperations: Option[Iterable[zio.aws.apigateway.model.PatchOperation]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartRequest = {
    import UpdateDocumentationPartRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .documentationPartId(documentationPartId: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.UpdateDocumentationPartRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateDocumentationPartRequest
      .wrap(buildAwsValue())
}
object UpdateDocumentationPartRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateDocumentationPartRequest =
      zio.aws.apigateway.model.UpdateDocumentationPartRequest(
        restApiId,
        documentationPartId,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def restApiId: String
    def documentationPartId: String
    def patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getDocumentationPartId: ZIO[Any, Nothing, String] =
      ZIO.succeed(documentationPartId)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartRequest
  ) extends zio.aws.apigateway.model.UpdateDocumentationPartRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val documentationPartId: String =
      impl.documentationPartId(): String
    override val patchOperations
        : Option[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] = scala
      .Option(impl.patchOperations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.PatchOperation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateDocumentationPartRequest
  ): zio.aws.apigateway.model.UpdateDocumentationPartRequest.ReadOnly =
    new Wrapper(impl)
}
