package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TestInvokeAuthorizerRequest(
    restApiId: String,
    authorizerId: String,
    headers: Option[Map[String, String]] = None,
    multiValueHeaders: Option[Map[String, Iterable[String]]] = None,
    pathWithQueryString: Option[String] = None,
    body: Option[String] = None,
    stageVariables: Option[Map[String, String]] = None,
    additionalContext: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest = {
    import TestInvokeAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .authorizerId(authorizerId: java.lang.String)
      .optionallyWith(
        headers.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.headers)
      .optionallyWith(
        multiValueHeaders.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.multiValueHeaders)
      .optionallyWith(
        pathWithQueryString.map(value => value: java.lang.String)
      )(_.pathWithQueryString)
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        stageVariables.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.stageVariables)
      .optionallyWith(
        additionalContext.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.additionalContext)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.TestInvokeAuthorizerRequest.ReadOnly =
    zio.aws.apigateway.model.TestInvokeAuthorizerRequest.wrap(buildAwsValue())
}
object TestInvokeAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.TestInvokeAuthorizerRequest =
      zio.aws.apigateway.model.TestInvokeAuthorizerRequest(
        restApiId,
        authorizerId,
        headers.map(value => value),
        multiValueHeaders.map(value => value),
        pathWithQueryString.map(value => value),
        body.map(value => value),
        stageVariables.map(value => value),
        additionalContext.map(value => value)
      )
    def restApiId: String
    def authorizerId: String
    def headers: Option[Map[String, String]]
    def multiValueHeaders: Option[Map[String, List[String]]]
    def pathWithQueryString: Option[String]
    def body: Option[String]
    def stageVariables: Option[Map[String, String]]
    def additionalContext: Option[Map[String, String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getAuthorizerId: ZIO[Any, Nothing, String] = ZIO.succeed(authorizerId)
    def getHeaders: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("headers", headers)
    def getMultiValueHeaders: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("multiValueHeaders", multiValueHeaders)
    def getPathWithQueryString: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pathWithQueryString", pathWithQueryString)
    def getBody: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("body", body)
    def getStageVariables: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("stageVariables", stageVariables)
    def getAdditionalContext: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("additionalContext", additionalContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest
  ) extends zio.aws.apigateway.model.TestInvokeAuthorizerRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val authorizerId: String = impl.authorizerId(): String
    override val headers: Option[Map[String, String]] = scala
      .Option(impl.headers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val multiValueHeaders: Option[Map[String, List[String]]] = scala
      .Option(impl.multiValueHeaders())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> value.asScala.map { item =>
              item: String
            }.toList
          })
          .toMap
      )
    override val pathWithQueryString: Option[String] =
      scala.Option(impl.pathWithQueryString()).map(value => value: String)
    override val body: Option[String] =
      scala.Option(impl.body()).map(value => value: String)
    override val stageVariables: Option[Map[String, String]] = scala
      .Option(impl.stageVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val additionalContext: Option[Map[String, String]] = scala
      .Option(impl.additionalContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerRequest
  ): zio.aws.apigateway.model.TestInvokeAuthorizerRequest.ReadOnly =
    new Wrapper(impl)
}
