package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StageKey(
    restApiId: Option[String] = None,
    stageName: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.StageKey = {
    import StageKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.StageKey
      .builder()
      .optionallyWith(restApiId.map(value => value: java.lang.String))(
        _.restApiId
      )
      .optionallyWith(stageName.map(value => value: java.lang.String))(
        _.stageName
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.StageKey.ReadOnly =
    zio.aws.apigateway.model.StageKey.wrap(buildAwsValue())
}
object StageKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.StageKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.StageKey = zio.aws.apigateway.model
      .StageKey(restApiId.map(value => value), stageName.map(value => value))
    def restApiId: Option[String]
    def stageName: Option[String]
    def getRestApiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restApiId", restApiId)
    def getStageName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stageName", stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.StageKey
  ) extends zio.aws.apigateway.model.StageKey.ReadOnly {
    override val restApiId: Option[String] =
      scala.Option(impl.restApiId()).map(value => value: String)
    override val stageName: Option[String] =
      scala.Option(impl.stageName()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.StageKey
  ): zio.aws.apigateway.model.StageKey.ReadOnly = new Wrapper(impl)
}
