package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class QuotaSettings(
    limit: Option[Integer] = None,
    offset: Option[Integer] = None,
    period: Option[zio.aws.apigateway.model.QuotaPeriodType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.QuotaSettings = {
    import QuotaSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.QuotaSettings
      .builder()
      .optionallyWith(
        limit.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.limit)
      .optionallyWith(
        offset.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.offset)
      .optionallyWith(period.map(value => value.unwrap))(_.period)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.QuotaSettings.ReadOnly =
    zio.aws.apigateway.model.QuotaSettings.wrap(buildAwsValue())
}
object QuotaSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.QuotaSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.QuotaSettings =
      zio.aws.apigateway.model.QuotaSettings(
        limit.map(value => value),
        offset.map(value => value),
        period.map(value => value)
      )
    def limit: Option[Integer]
    def offset: Option[Integer]
    def period: Option[zio.aws.apigateway.model.QuotaPeriodType]
    def getLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("limit", limit)
    def getOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("offset", offset)
    def getPeriod
        : ZIO[Any, AwsError, zio.aws.apigateway.model.QuotaPeriodType] =
      AwsError.unwrapOptionField("period", period)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.QuotaSettings
  ) extends zio.aws.apigateway.model.QuotaSettings.ReadOnly {
    override val limit: Option[Integer] = scala
      .Option(impl.limit())
      .map(value => zio.aws.apigateway.model.primitives.Integer(value))
    override val offset: Option[Integer] = scala
      .Option(impl.offset())
      .map(value => zio.aws.apigateway.model.primitives.Integer(value))
    override val period: Option[zio.aws.apigateway.model.QuotaPeriodType] =
      scala
        .Option(impl.period())
        .map(value => zio.aws.apigateway.model.QuotaPeriodType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.QuotaSettings
  ): zio.aws.apigateway.model.QuotaSettings.ReadOnly = new Wrapper(impl)
}
