package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.Blob
import scala.jdk.CollectionConverters._
final case class ImportRestApiRequest(
    failOnWarnings: Option[Boolean] = None,
    parameters: Option[Map[String, String]] = None,
    body: Blob
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest = {
    import ImportRestApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest
      .builder()
      .optionallyWith(failOnWarnings.map(value => value: java.lang.Boolean))(
        _.failOnWarnings
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .body(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(body.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.ImportRestApiRequest.ReadOnly =
    zio.aws.apigateway.model.ImportRestApiRequest.wrap(buildAwsValue())
}
object ImportRestApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.ImportRestApiRequest =
      zio.aws.apigateway.model.ImportRestApiRequest(
        failOnWarnings.map(value => value),
        parameters.map(value => value),
        body
      )
    def failOnWarnings: Option[Boolean]
    def parameters: Option[Map[String, String]]
    def body: Blob
    def getFailOnWarnings: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("failOnWarnings", failOnWarnings)
    def getParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getBody: ZIO[Any, Nothing, Blob] = ZIO.succeed(body)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest
  ) extends zio.aws.apigateway.model.ImportRestApiRequest.ReadOnly {
    override val failOnWarnings: Option[Boolean] =
      scala.Option(impl.failOnWarnings()).map(value => value: Boolean)
    override val parameters: Option[Map[String, String]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val body: Blob = zio.aws.apigateway.model.primitives
      .Blob(zio.Chunk.fromArray(impl.body().asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest
  ): zio.aws.apigateway.model.ImportRestApiRequest.ReadOnly = new Wrapper(impl)
}
