package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableInteger
import scala.jdk.CollectionConverters._
final case class GetSdkTypesRequest(
    position: Option[String] = None,
    limit: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetSdkTypesRequest = {
    import GetSdkTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetSdkTypesRequest
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        limit.map(value => NullableInteger.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetSdkTypesRequest.ReadOnly =
    zio.aws.apigateway.model.GetSdkTypesRequest.wrap(buildAwsValue())
}
object GetSdkTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetSdkTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetSdkTypesRequest =
      zio.aws.apigateway.model.GetSdkTypesRequest(
        position.map(value => value),
        limit.map(value => value)
      )
    def position: Option[String]
    def limit: Option[NullableInteger]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getLimit: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetSdkTypesRequest
  ) extends zio.aws.apigateway.model.GetSdkTypesRequest.ReadOnly {
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val limit: Option[NullableInteger] = scala
      .Option(impl.limit())
      .map(value => zio.aws.apigateway.model.primitives.NullableInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetSdkTypesRequest
  ): zio.aws.apigateway.model.GetSdkTypesRequest.ReadOnly = new Wrapper(impl)
}
