package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.apigateway.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class GetDomainNameResponse(
    domainName: Option[String] = None,
    certificateName: Option[String] = None,
    certificateArn: Option[String] = None,
    certificateUploadDate: Option[Timestamp] = None,
    regionalDomainName: Option[String] = None,
    regionalHostedZoneId: Option[String] = None,
    regionalCertificateName: Option[String] = None,
    regionalCertificateArn: Option[String] = None,
    distributionDomainName: Option[String] = None,
    distributionHostedZoneId: Option[String] = None,
    endpointConfiguration: Option[
      zio.aws.apigateway.model.EndpointConfiguration
    ] = None,
    domainNameStatus: Option[zio.aws.apigateway.model.DomainNameStatus] = None,
    domainNameStatusMessage: Option[String] = None,
    securityPolicy: Option[zio.aws.apigateway.model.SecurityPolicy] = None,
    tags: Option[Map[String, String]] = None,
    mutualTlsAuthentication: Option[
      zio.aws.apigateway.model.MutualTlsAuthentication
    ] = None,
    ownershipVerificationCertificateArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse = {
    import GetDomainNameResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse
      .builder()
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(certificateName.map(value => value: java.lang.String))(
        _.certificateName
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(
        certificateUploadDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.certificateUploadDate)
      .optionallyWith(regionalDomainName.map(value => value: java.lang.String))(
        _.regionalDomainName
      )
      .optionallyWith(
        regionalHostedZoneId.map(value => value: java.lang.String)
      )(_.regionalHostedZoneId)
      .optionallyWith(
        regionalCertificateName.map(value => value: java.lang.String)
      )(_.regionalCertificateName)
      .optionallyWith(
        regionalCertificateArn.map(value => value: java.lang.String)
      )(_.regionalCertificateArn)
      .optionallyWith(
        distributionDomainName.map(value => value: java.lang.String)
      )(_.distributionDomainName)
      .optionallyWith(
        distributionHostedZoneId.map(value => value: java.lang.String)
      )(_.distributionHostedZoneId)
      .optionallyWith(
        endpointConfiguration.map(value => value.buildAwsValue())
      )(_.endpointConfiguration)
      .optionallyWith(domainNameStatus.map(value => value.unwrap))(
        _.domainNameStatus
      )
      .optionallyWith(
        domainNameStatusMessage.map(value => value: java.lang.String)
      )(_.domainNameStatusMessage)
      .optionallyWith(securityPolicy.map(value => value.unwrap))(
        _.securityPolicy
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        mutualTlsAuthentication.map(value => value.buildAwsValue())
      )(_.mutualTlsAuthentication)
      .optionallyWith(
        ownershipVerificationCertificateArn.map(value =>
          value: java.lang.String
        )
      )(_.ownershipVerificationCertificateArn)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetDomainNameResponse.ReadOnly =
    zio.aws.apigateway.model.GetDomainNameResponse.wrap(buildAwsValue())
}
object GetDomainNameResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetDomainNameResponse =
      zio.aws.apigateway.model.GetDomainNameResponse(
        domainName.map(value => value),
        certificateName.map(value => value),
        certificateArn.map(value => value),
        certificateUploadDate.map(value => value),
        regionalDomainName.map(value => value),
        regionalHostedZoneId.map(value => value),
        regionalCertificateName.map(value => value),
        regionalCertificateArn.map(value => value),
        distributionDomainName.map(value => value),
        distributionHostedZoneId.map(value => value),
        endpointConfiguration.map(value => value.asEditable),
        domainNameStatus.map(value => value),
        domainNameStatusMessage.map(value => value),
        securityPolicy.map(value => value),
        tags.map(value => value),
        mutualTlsAuthentication.map(value => value.asEditable),
        ownershipVerificationCertificateArn.map(value => value)
      )
    def domainName: Option[String]
    def certificateName: Option[String]
    def certificateArn: Option[String]
    def certificateUploadDate: Option[Timestamp]
    def regionalDomainName: Option[String]
    def regionalHostedZoneId: Option[String]
    def regionalCertificateName: Option[String]
    def regionalCertificateArn: Option[String]
    def distributionDomainName: Option[String]
    def distributionHostedZoneId: Option[String]
    def endpointConfiguration
        : Option[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly]
    def domainNameStatus: Option[zio.aws.apigateway.model.DomainNameStatus]
    def domainNameStatusMessage: Option[String]
    def securityPolicy: Option[zio.aws.apigateway.model.SecurityPolicy]
    def tags: Option[Map[String, String]]
    def mutualTlsAuthentication
        : Option[zio.aws.apigateway.model.MutualTlsAuthentication.ReadOnly]
    def ownershipVerificationCertificateArn: Option[String]
    def getDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getCertificateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateUploadDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("certificateUploadDate", certificateUploadDate)
    def getRegionalDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("regionalDomainName", regionalDomainName)
    def getRegionalHostedZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("regionalHostedZoneId", regionalHostedZoneId)
    def getRegionalCertificateName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("regionalCertificateName", regionalCertificateName)
    def getRegionalCertificateArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("regionalCertificateArn", regionalCertificateArn)
    def getDistributionDomainName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("distributionDomainName", distributionDomainName)
    def getDistributionHostedZoneId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("distributionHostedZoneId", distributionHostedZoneId)
    def getEndpointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.EndpointConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("endpointConfiguration", endpointConfiguration)
    def getDomainNameStatus
        : ZIO[Any, AwsError, zio.aws.apigateway.model.DomainNameStatus] =
      AwsError.unwrapOptionField("domainNameStatus", domainNameStatus)
    def getDomainNameStatusMessage: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("domainNameStatusMessage", domainNameStatusMessage)
    def getSecurityPolicy
        : ZIO[Any, AwsError, zio.aws.apigateway.model.SecurityPolicy] =
      AwsError.unwrapOptionField("securityPolicy", securityPolicy)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getMutualTlsAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.MutualTlsAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mutualTlsAuthentication",
      mutualTlsAuthentication
    )
    def getOwnershipVerificationCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "ownershipVerificationCertificateArn",
        ownershipVerificationCertificateArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse
  ) extends zio.aws.apigateway.model.GetDomainNameResponse.ReadOnly {
    override val domainName: Option[String] =
      scala.Option(impl.domainName()).map(value => value: String)
    override val certificateName: Option[String] =
      scala.Option(impl.certificateName()).map(value => value: String)
    override val certificateArn: Option[String] =
      scala.Option(impl.certificateArn()).map(value => value: String)
    override val certificateUploadDate: Option[Timestamp] = scala
      .Option(impl.certificateUploadDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val regionalDomainName: Option[String] =
      scala.Option(impl.regionalDomainName()).map(value => value: String)
    override val regionalHostedZoneId: Option[String] =
      scala.Option(impl.regionalHostedZoneId()).map(value => value: String)
    override val regionalCertificateName: Option[String] =
      scala.Option(impl.regionalCertificateName()).map(value => value: String)
    override val regionalCertificateArn: Option[String] =
      scala.Option(impl.regionalCertificateArn()).map(value => value: String)
    override val distributionDomainName: Option[String] =
      scala.Option(impl.distributionDomainName()).map(value => value: String)
    override val distributionHostedZoneId: Option[String] =
      scala.Option(impl.distributionHostedZoneId()).map(value => value: String)
    override val endpointConfiguration
        : Option[zio.aws.apigateway.model.EndpointConfiguration.ReadOnly] =
      scala
        .Option(impl.endpointConfiguration())
        .map(value =>
          zio.aws.apigateway.model.EndpointConfiguration.wrap(value)
        )
    override val domainNameStatus
        : Option[zio.aws.apigateway.model.DomainNameStatus] = scala
      .Option(impl.domainNameStatus())
      .map(value => zio.aws.apigateway.model.DomainNameStatus.wrap(value))
    override val domainNameStatusMessage: Option[String] =
      scala.Option(impl.domainNameStatusMessage()).map(value => value: String)
    override val securityPolicy
        : Option[zio.aws.apigateway.model.SecurityPolicy] = scala
      .Option(impl.securityPolicy())
      .map(value => zio.aws.apigateway.model.SecurityPolicy.wrap(value))
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val mutualTlsAuthentication
        : Option[zio.aws.apigateway.model.MutualTlsAuthentication.ReadOnly] =
      scala
        .Option(impl.mutualTlsAuthentication())
        .map(value =>
          zio.aws.apigateway.model.MutualTlsAuthentication.wrap(value)
        )
    override val ownershipVerificationCertificateArn: Option[String] = scala
      .Option(impl.ownershipVerificationCertificateArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetDomainNameResponse
  ): zio.aws.apigateway.model.GetDomainNameResponse.ReadOnly = new Wrapper(impl)
}
