package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteIntegrationRequest(
    restApiId: String,
    resourceId: String,
    httpMethod: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteIntegrationRequest = {
    import DeleteIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteIntegrationRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .httpMethod(httpMethod: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeleteIntegrationRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteIntegrationRequest.wrap(buildAwsValue())
}
object DeleteIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteIntegrationRequest =
      zio.aws.apigateway.model
        .DeleteIntegrationRequest(restApiId, resourceId, httpMethod)
    def restApiId: String
    def resourceId: String
    def httpMethod: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getHttpMethod: ZIO[Any, Nothing, String] = ZIO.succeed(httpMethod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteIntegrationRequest
  ) extends zio.aws.apigateway.model.DeleteIntegrationRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val httpMethod: String = impl.httpMethod(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteIntegrationRequest
  ): zio.aws.apigateway.model.DeleteIntegrationRequest.ReadOnly = new Wrapper(
    impl
  )
}
