package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteApiKeyRequest(apiKey: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteApiKeyRequest = {
    import DeleteApiKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteApiKeyRequest
      .builder()
      .apiKey(apiKey: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.DeleteApiKeyRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteApiKeyRequest.wrap(buildAwsValue())
}
object DeleteApiKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteApiKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteApiKeyRequest =
      zio.aws.apigateway.model.DeleteApiKeyRequest(apiKey)
    def apiKey: String
    def getApiKey: ZIO[Any, Nothing, String] = ZIO.succeed(apiKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteApiKeyRequest
  ) extends zio.aws.apigateway.model.DeleteApiKeyRequest.ReadOnly {
    override val apiKey: String = impl.apiKey(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteApiKeyRequest
  ): zio.aws.apigateway.model.DeleteApiKeyRequest.ReadOnly = new Wrapper(impl)
}
