package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.apigateway.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class UpdateClientCertificateResponse(
    clientCertificateId: Option[String] = None,
    description: Option[String] = None,
    pemEncodedCertificate: Option[String] = None,
    createdDate: Option[Timestamp] = None,
    expirationDate: Option[Timestamp] = None,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateResponse = {
    import UpdateClientCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateResponse
      .builder()
      .optionallyWith(
        clientCertificateId.map(value => value: java.lang.String)
      )(_.clientCertificateId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        pemEncodedCertificate.map(value => value: java.lang.String)
      )(_.pemEncodedCertificate)
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        expirationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationDate)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.UpdateClientCertificateResponse.ReadOnly =
    zio.aws.apigateway.model.UpdateClientCertificateResponse
      .wrap(buildAwsValue())
}
object UpdateClientCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateClientCertificateResponse =
      zio.aws.apigateway.model.UpdateClientCertificateResponse(
        clientCertificateId.map(value => value),
        description.map(value => value),
        pemEncodedCertificate.map(value => value),
        createdDate.map(value => value),
        expirationDate.map(value => value),
        tags.map(value => value)
      )
    def clientCertificateId: Option[String]
    def description: Option[String]
    def pemEncodedCertificate: Option[String]
    def createdDate: Option[Timestamp]
    def expirationDate: Option[Timestamp]
    def tags: Option[Map[String, String]]
    def getClientCertificateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getPemEncodedCertificate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pemEncodedCertificate", pemEncodedCertificate)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getExpirationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationDate", expirationDate)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateResponse
  ) extends zio.aws.apigateway.model.UpdateClientCertificateResponse.ReadOnly {
    override val clientCertificateId: Option[String] =
      scala.Option(impl.clientCertificateId()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val pemEncodedCertificate: Option[String] =
      scala.Option(impl.pemEncodedCertificate()).map(value => value: String)
    override val createdDate: Option[Timestamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val expirationDate: Option[Timestamp] = scala
      .Option(impl.expirationDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateResponse
  ): zio.aws.apigateway.model.UpdateClientCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
