package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.apigateway.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class GetStageResponse(
    deploymentId: Option[String] = None,
    clientCertificateId: Option[String] = None,
    stageName: Option[String] = None,
    description: Option[String] = None,
    cacheClusterEnabled: Option[Boolean] = None,
    cacheClusterSize: Option[String] = None,
    cacheClusterStatus: Option[zio.aws.apigateway.model.CacheClusterStatus] =
      None,
    methodSettings: Option[
      Map[String, zio.aws.apigateway.model.MethodSetting]
    ] = None,
    variables: Option[Map[String, String]] = None,
    documentationVersion: Option[String] = None,
    accessLogSettings: Option[zio.aws.apigateway.model.AccessLogSettings] =
      None,
    canarySettings: Option[zio.aws.apigateway.model.CanarySettings] = None,
    tracingEnabled: Option[Boolean] = None,
    webAclArn: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    createdDate: Option[Timestamp] = None,
    lastUpdatedDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetStageResponse = {
    import GetStageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetStageResponse
      .builder()
      .optionallyWith(deploymentId.map(value => value: java.lang.String))(
        _.deploymentId
      )
      .optionallyWith(
        clientCertificateId.map(value => value: java.lang.String)
      )(_.clientCertificateId)
      .optionallyWith(stageName.map(value => value: java.lang.String))(
        _.stageName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        cacheClusterEnabled.map(value => value: java.lang.Boolean)
      )(_.cacheClusterEnabled)
      .optionallyWith(cacheClusterSize.map(value => value: java.lang.String))(
        _.cacheClusterSize
      )
      .optionallyWith(cacheClusterStatus.map(value => value.unwrap))(
        _.cacheClusterStatus
      )
      .optionallyWith(
        methodSettings.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.methodSettings)
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.variables)
      .optionallyWith(
        documentationVersion.map(value => value: java.lang.String)
      )(_.documentationVersion)
      .optionallyWith(accessLogSettings.map(value => value.buildAwsValue()))(
        _.accessLogSettings
      )
      .optionallyWith(canarySettings.map(value => value.buildAwsValue()))(
        _.canarySettings
      )
      .optionallyWith(tracingEnabled.map(value => value: java.lang.Boolean))(
        _.tracingEnabled
      )
      .optionallyWith(webAclArn.map(value => value: java.lang.String))(
        _.webAclArn
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        lastUpdatedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDate)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetStageResponse.ReadOnly =
    zio.aws.apigateway.model.GetStageResponse.wrap(buildAwsValue())
}
object GetStageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetStageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetStageResponse =
      zio.aws.apigateway.model.GetStageResponse(
        deploymentId.map(value => value),
        clientCertificateId.map(value => value),
        stageName.map(value => value),
        description.map(value => value),
        cacheClusterEnabled.map(value => value),
        cacheClusterSize.map(value => value),
        cacheClusterStatus.map(value => value),
        methodSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        variables.map(value => value),
        documentationVersion.map(value => value),
        accessLogSettings.map(value => value.asEditable),
        canarySettings.map(value => value.asEditable),
        tracingEnabled.map(value => value),
        webAclArn.map(value => value),
        tags.map(value => value),
        createdDate.map(value => value),
        lastUpdatedDate.map(value => value)
      )
    def deploymentId: Option[String]
    def clientCertificateId: Option[String]
    def stageName: Option[String]
    def description: Option[String]
    def cacheClusterEnabled: Option[Boolean]
    def cacheClusterSize: Option[String]
    def cacheClusterStatus: Option[zio.aws.apigateway.model.CacheClusterStatus]
    def methodSettings
        : Option[Map[String, zio.aws.apigateway.model.MethodSetting.ReadOnly]]
    def variables: Option[Map[String, String]]
    def documentationVersion: Option[String]
    def accessLogSettings
        : Option[zio.aws.apigateway.model.AccessLogSettings.ReadOnly]
    def canarySettings: Option[zio.aws.apigateway.model.CanarySettings.ReadOnly]
    def tracingEnabled: Option[Boolean]
    def webAclArn: Option[String]
    def tags: Option[Map[String, String]]
    def createdDate: Option[Timestamp]
    def lastUpdatedDate: Option[Timestamp]
    def getDeploymentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getClientCertificateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getStageName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getCacheClusterEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cacheClusterEnabled", cacheClusterEnabled)
    def getCacheClusterSize: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterSize", cacheClusterSize)
    def getCacheClusterStatus
        : ZIO[Any, AwsError, zio.aws.apigateway.model.CacheClusterStatus] =
      AwsError.unwrapOptionField("cacheClusterStatus", cacheClusterStatus)
    def getMethodSettings: ZIO[Any, AwsError, Map[
      String,
      zio.aws.apigateway.model.MethodSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("methodSettings", methodSettings)
    def getVariables: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("variables", variables)
    def getDocumentationVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("documentationVersion", documentationVersion)
    def getAccessLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.AccessLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogSettings", accessLogSettings)
    def getCanarySettings
        : ZIO[Any, AwsError, zio.aws.apigateway.model.CanarySettings.ReadOnly] =
      AwsError.unwrapOptionField("canarySettings", canarySettings)
    def getTracingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("tracingEnabled", tracingEnabled)
    def getWebAclArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("webAclArn", webAclArn)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getLastUpdatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetStageResponse
  ) extends zio.aws.apigateway.model.GetStageResponse.ReadOnly {
    override val deploymentId: Option[String] =
      scala.Option(impl.deploymentId()).map(value => value: String)
    override val clientCertificateId: Option[String] =
      scala.Option(impl.clientCertificateId()).map(value => value: String)
    override val stageName: Option[String] =
      scala.Option(impl.stageName()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val cacheClusterEnabled: Option[Boolean] =
      scala.Option(impl.cacheClusterEnabled()).map(value => value: Boolean)
    override val cacheClusterSize: Option[String] =
      scala.Option(impl.cacheClusterSize()).map(value => value: String)
    override val cacheClusterStatus
        : Option[zio.aws.apigateway.model.CacheClusterStatus] = scala
      .Option(impl.cacheClusterStatus())
      .map(value => zio.aws.apigateway.model.CacheClusterStatus.wrap(value))
    override val methodSettings
        : Option[Map[String, zio.aws.apigateway.model.MethodSetting.ReadOnly]] =
      scala
        .Option(impl.methodSettings())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.apigateway.model.MethodSetting
                .wrap(value)
            })
            .toMap
        )
    override val variables: Option[Map[String, String]] = scala
      .Option(impl.variables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val documentationVersion: Option[String] =
      scala.Option(impl.documentationVersion()).map(value => value: String)
    override val accessLogSettings
        : Option[zio.aws.apigateway.model.AccessLogSettings.ReadOnly] = scala
      .Option(impl.accessLogSettings())
      .map(value => zio.aws.apigateway.model.AccessLogSettings.wrap(value))
    override val canarySettings
        : Option[zio.aws.apigateway.model.CanarySettings.ReadOnly] = scala
      .Option(impl.canarySettings())
      .map(value => zio.aws.apigateway.model.CanarySettings.wrap(value))
    override val tracingEnabled: Option[Boolean] =
      scala.Option(impl.tracingEnabled()).map(value => value: Boolean)
    override val webAclArn: Option[String] =
      scala.Option(impl.webAclArn()).map(value => value: String)
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val createdDate: Option[Timestamp] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val lastUpdatedDate: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetStageResponse
  ): zio.aws.apigateway.model.GetStageResponse.ReadOnly = new Wrapper(impl)
}
