package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetResourceResponse(
    id: Option[String] = None,
    parentId: Option[String] = None,
    pathPart: Option[String] = None,
    path: Option[String] = None,
    resourceMethods: Option[Map[String, zio.aws.apigateway.model.Method]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetResourceResponse = {
    import GetResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetResourceResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(parentId.map(value => value: java.lang.String))(
        _.parentId
      )
      .optionallyWith(pathPart.map(value => value: java.lang.String))(
        _.pathPart
      )
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(
        resourceMethods.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.resourceMethods)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetResourceResponse.ReadOnly =
    zio.aws.apigateway.model.GetResourceResponse.wrap(buildAwsValue())
}
object GetResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetResourceResponse =
      zio.aws.apigateway.model.GetResourceResponse(
        id.map(value => value),
        parentId.map(value => value),
        pathPart.map(value => value),
        path.map(value => value),
        resourceMethods.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def id: Option[String]
    def parentId: Option[String]
    def pathPart: Option[String]
    def path: Option[String]
    def resourceMethods
        : Option[Map[String, zio.aws.apigateway.model.Method.ReadOnly]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getParentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parentId", parentId)
    def getPathPart: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pathPart", pathPart)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getResourceMethods: ZIO[Any, AwsError, Map[
      String,
      zio.aws.apigateway.model.Method.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceMethods", resourceMethods)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetResourceResponse
  ) extends zio.aws.apigateway.model.GetResourceResponse.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val parentId: Option[String] =
      scala.Option(impl.parentId()).map(value => value: String)
    override val pathPart: Option[String] =
      scala.Option(impl.pathPart()).map(value => value: String)
    override val path: Option[String] =
      scala.Option(impl.path()).map(value => value: String)
    override val resourceMethods
        : Option[Map[String, zio.aws.apigateway.model.Method.ReadOnly]] = scala
      .Option(impl.resourceMethods())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.apigateway.model.Method.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetResourceResponse
  ): zio.aws.apigateway.model.GetResourceResponse.ReadOnly = new Wrapper(impl)
}
