package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetExportRequest(
    restApiId: String,
    stageName: String,
    exportType: String,
    parameters: Option[Map[String, String]] = None,
    accepts: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetExportRequest = {
    import GetExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetExportRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .stageName(stageName: java.lang.String)
      .exportType(exportType: java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(accepts.map(value => value: java.lang.String))(_.accepts)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetExportRequest.ReadOnly =
    zio.aws.apigateway.model.GetExportRequest.wrap(buildAwsValue())
}
object GetExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetExportRequest =
      zio.aws.apigateway.model.GetExportRequest(
        restApiId,
        stageName,
        exportType,
        parameters.map(value => value),
        accepts.map(value => value)
      )
    def restApiId: String
    def stageName: String
    def exportType: String
    def parameters: Option[Map[String, String]]
    def accepts: Option[String]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getStageName: ZIO[Any, Nothing, String] = ZIO.succeed(stageName)
    def getExportType: ZIO[Any, Nothing, String] = ZIO.succeed(exportType)
    def getParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getAccepts: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accepts", accepts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetExportRequest
  ) extends zio.aws.apigateway.model.GetExportRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val stageName: String = impl.stageName(): String
    override val exportType: String = impl.exportType(): String
    override val parameters: Option[Map[String, String]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val accepts: Option[String] =
      scala.Option(impl.accepts()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetExportRequest
  ): zio.aws.apigateway.model.GetExportRequest.ReadOnly = new Wrapper(impl)
}
