package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetBasePathMappingsResponse(
    position: Option[String] = None,
    items: Option[Iterable[zio.aws.apigateway.model.BasePathMapping]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse = {
    import GetBasePathMappingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.GetBasePathMappingsResponse.ReadOnly =
    zio.aws.apigateway.model.GetBasePathMappingsResponse.wrap(buildAwsValue())
}
object GetBasePathMappingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetBasePathMappingsResponse =
      zio.aws.apigateway.model.GetBasePathMappingsResponse(
        position.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def position: Option[String]
    def items: Option[List[zio.aws.apigateway.model.BasePathMapping.ReadOnly]]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.BasePathMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse
  ) extends zio.aws.apigateway.model.GetBasePathMappingsResponse.ReadOnly {
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val items
        : Option[List[zio.aws.apigateway.model.BasePathMapping.ReadOnly]] =
      scala
        .Option(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.BasePathMapping.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetBasePathMappingsResponse
  ): zio.aws.apigateway.model.GetBasePathMappingsResponse.ReadOnly =
    new Wrapper(impl)
}
