package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetApiKeysResponse(
    warnings: Option[Iterable[String]] = None,
    position: Option[String] = None,
    items: Option[Iterable[zio.aws.apigateway.model.ApiKey]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse = {
    import GetApiKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse
      .builder()
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.warnings)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetApiKeysResponse.ReadOnly =
    zio.aws.apigateway.model.GetApiKeysResponse.wrap(buildAwsValue())
}
object GetApiKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetApiKeysResponse =
      zio.aws.apigateway.model.GetApiKeysResponse(
        warnings.map(value => value),
        position.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def warnings: Option[List[String]]
    def position: Option[String]
    def items: Option[List[zio.aws.apigateway.model.ApiKey.ReadOnly]]
    def getWarnings: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.apigateway.model.ApiKey.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse
  ) extends zio.aws.apigateway.model.GetApiKeysResponse.ReadOnly {
    override val warnings: Option[List[String]] = scala
      .Option(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val items: Option[List[zio.aws.apigateway.model.ApiKey.ReadOnly]] =
      scala
        .Option(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.ApiKey.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetApiKeysResponse
  ): zio.aws.apigateway.model.GetApiKeysResponse.ReadOnly = new Wrapper(impl)
}
