package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetUsagePlanResponse(
    id: Option[String] = None,
    name: Option[String] = None,
    description: Option[String] = None,
    apiStages: Option[Iterable[zio.aws.apigateway.model.ApiStage]] = None,
    throttle: Option[zio.aws.apigateway.model.ThrottleSettings] = None,
    quota: Option[zio.aws.apigateway.model.QuotaSettings] = None,
    productCode: Option[String] = None,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetUsagePlanResponse = {
    import GetUsagePlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetUsagePlanResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        apiStages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.apiStages)
      .optionallyWith(throttle.map(value => value.buildAwsValue()))(_.throttle)
      .optionallyWith(quota.map(value => value.buildAwsValue()))(_.quota)
      .optionallyWith(productCode.map(value => value: java.lang.String))(
        _.productCode
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetUsagePlanResponse.ReadOnly =
    zio.aws.apigateway.model.GetUsagePlanResponse.wrap(buildAwsValue())
}
object GetUsagePlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetUsagePlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetUsagePlanResponse =
      zio.aws.apigateway.model.GetUsagePlanResponse(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        apiStages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        throttle.map(value => value.asEditable),
        quota.map(value => value.asEditable),
        productCode.map(value => value),
        tags.map(value => value)
      )
    def id: Option[String]
    def name: Option[String]
    def description: Option[String]
    def apiStages: Option[List[zio.aws.apigateway.model.ApiStage.ReadOnly]]
    def throttle: Option[zio.aws.apigateway.model.ThrottleSettings.ReadOnly]
    def quota: Option[zio.aws.apigateway.model.QuotaSettings.ReadOnly]
    def productCode: Option[String]
    def tags: Option[Map[String, String]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getApiStages
        : ZIO[Any, AwsError, List[zio.aws.apigateway.model.ApiStage.ReadOnly]] =
      AwsError.unwrapOptionField("apiStages", apiStages)
    def getThrottle: ZIO[
      Any,
      AwsError,
      zio.aws.apigateway.model.ThrottleSettings.ReadOnly
    ] = AwsError.unwrapOptionField("throttle", throttle)
    def getQuota
        : ZIO[Any, AwsError, zio.aws.apigateway.model.QuotaSettings.ReadOnly] =
      AwsError.unwrapOptionField("quota", quota)
    def getProductCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productCode", productCode)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlanResponse
  ) extends zio.aws.apigateway.model.GetUsagePlanResponse.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val apiStages
        : Option[List[zio.aws.apigateway.model.ApiStage.ReadOnly]] = scala
      .Option(impl.apiStages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.ApiStage.wrap(item)
        }.toList
      )
    override val throttle
        : Option[zio.aws.apigateway.model.ThrottleSettings.ReadOnly] = scala
      .Option(impl.throttle())
      .map(value => zio.aws.apigateway.model.ThrottleSettings.wrap(value))
    override val quota
        : Option[zio.aws.apigateway.model.QuotaSettings.ReadOnly] = scala
      .Option(impl.quota())
      .map(value => zio.aws.apigateway.model.QuotaSettings.wrap(value))
    override val productCode: Option[String] =
      scala.Option(impl.productCode()).map(value => value: String)
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetUsagePlanResponse
  ): zio.aws.apigateway.model.GetUsagePlanResponse.ReadOnly = new Wrapper(impl)
}
