package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetResourcesResponse(
    position: Option[String] = None,
    items: Option[Iterable[zio.aws.apigateway.model.Resource]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetResourcesResponse = {
    import GetResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetResourcesResponse
      .builder()
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetResourcesResponse.ReadOnly =
    zio.aws.apigateway.model.GetResourcesResponse.wrap(buildAwsValue())
}
object GetResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetResourcesResponse =
      zio.aws.apigateway.model.GetResourcesResponse(
        position.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def position: Option[String]
    def items: Option[List[zio.aws.apigateway.model.Resource.ReadOnly]]
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.apigateway.model.Resource.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetResourcesResponse
  ) extends zio.aws.apigateway.model.GetResourcesResponse.ReadOnly {
    override val position: Option[String] =
      scala.Option(impl.position()).map(value => value: String)
    override val items
        : Option[List[zio.aws.apigateway.model.Resource.ReadOnly]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.Resource.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetResourcesResponse
  ): zio.aws.apigateway.model.GetResourcesResponse.ReadOnly = new Wrapper(impl)
}
