package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.NullableBoolean
import scala.jdk.CollectionConverters._
final case class PutMethodRequest(
    restApiId: String,
    resourceId: String,
    httpMethod: String,
    authorizationType: String,
    authorizerId: Option[String] = None,
    apiKeyRequired: Option[Boolean] = None,
    operationName: Option[String] = None,
    requestParameters: Option[Map[String, NullableBoolean]] = None,
    requestModels: Option[Map[String, String]] = None,
    requestValidatorId: Option[String] = None,
    authorizationScopes: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.PutMethodRequest = {
    import PutMethodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.PutMethodRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .httpMethod(httpMethod: java.lang.String)
      .authorizationType(authorizationType: java.lang.String)
      .optionallyWith(authorizerId.map(value => value: java.lang.String))(
        _.authorizerId
      )
      .optionallyWith(apiKeyRequired.map(value => value: java.lang.Boolean))(
        _.apiKeyRequired
      )
      .optionallyWith(operationName.map(value => value: java.lang.String))(
        _.operationName
      )
      .optionallyWith(
        requestParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (NullableBoolean.unwrap(
                value
              ): java.lang.Boolean)
            })
            .asJava
        )
      )(_.requestParameters)
      .optionallyWith(
        requestModels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestModels)
      .optionallyWith(requestValidatorId.map(value => value: java.lang.String))(
        _.requestValidatorId
      )
      .optionallyWith(
        authorizationScopes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.authorizationScopes)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.PutMethodRequest.ReadOnly =
    zio.aws.apigateway.model.PutMethodRequest.wrap(buildAwsValue())
}
object PutMethodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.PutMethodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.PutMethodRequest =
      zio.aws.apigateway.model.PutMethodRequest(
        restApiId,
        resourceId,
        httpMethod,
        authorizationType,
        authorizerId.map(value => value),
        apiKeyRequired.map(value => value),
        operationName.map(value => value),
        requestParameters.map(value => value),
        requestModels.map(value => value),
        requestValidatorId.map(value => value),
        authorizationScopes.map(value => value)
      )
    def restApiId: String
    def resourceId: String
    def httpMethod: String
    def authorizationType: String
    def authorizerId: Option[String]
    def apiKeyRequired: Option[Boolean]
    def operationName: Option[String]
    def requestParameters: Option[Map[String, NullableBoolean]]
    def requestModels: Option[Map[String, String]]
    def requestValidatorId: Option[String]
    def authorizationScopes: Option[List[String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getHttpMethod: ZIO[Any, Nothing, String] = ZIO.succeed(httpMethod)
    def getAuthorizationType: ZIO[Any, Nothing, String] =
      ZIO.succeed(authorizationType)
    def getAuthorizerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizerId", authorizerId)
    def getApiKeyRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("apiKeyRequired", apiKeyRequired)
    def getOperationName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operationName", operationName)
    def getRequestParameters: ZIO[Any, AwsError, Map[String, NullableBoolean]] =
      AwsError.unwrapOptionField("requestParameters", requestParameters)
    def getRequestModels: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("requestModels", requestModels)
    def getRequestValidatorId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestValidatorId", requestValidatorId)
    def getAuthorizationScopes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("authorizationScopes", authorizationScopes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.PutMethodRequest
  ) extends zio.aws.apigateway.model.PutMethodRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val httpMethod: String = impl.httpMethod(): String
    override val authorizationType: String = impl.authorizationType(): String
    override val authorizerId: Option[String] =
      scala.Option(impl.authorizerId()).map(value => value: String)
    override val apiKeyRequired: Option[Boolean] =
      scala.Option(impl.apiKeyRequired()).map(value => value: Boolean)
    override val operationName: Option[String] =
      scala.Option(impl.operationName()).map(value => value: String)
    override val requestParameters: Option[Map[String, NullableBoolean]] = scala
      .Option(impl.requestParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.apigateway.model.primitives
              .NullableBoolean(value)
          })
          .toMap
      )
    override val requestModels: Option[Map[String, String]] = scala
      .Option(impl.requestModels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val requestValidatorId: Option[String] =
      scala.Option(impl.requestValidatorId()).map(value => value: String)
    override val authorizationScopes: Option[List[String]] = scala
      .Option(impl.authorizationScopes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.PutMethodRequest
  ): zio.aws.apigateway.model.PutMethodRequest.ReadOnly = new Wrapper(impl)
}
