package zio.aws.apigateway.model
import scala.jdk.CollectionConverters._
sealed trait ApiKeySourceType {
  def unwrap: software.amazon.awssdk.services.apigateway.model.ApiKeySourceType
}
object ApiKeySourceType {
  def wrap(
      value: software.amazon.awssdk.services.apigateway.model.ApiKeySourceType
  ): zio.aws.apigateway.model.ApiKeySourceType = value match {
    case software.amazon.awssdk.services.apigateway.model.ApiKeySourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigateway.model.ApiKeySourceType.HEADER =>
      val r = HEADER
      r
    case software.amazon.awssdk.services.apigateway.model.ApiKeySourceType.AUTHORIZER =>
      val r = AUTHORIZER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigateway.model.ApiKeySourceType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.ApiKeySourceType =
      software.amazon.awssdk.services.apigateway.model.ApiKeySourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object HEADER extends zio.aws.apigateway.model.ApiKeySourceType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.ApiKeySourceType =
      software.amazon.awssdk.services.apigateway.model.ApiKeySourceType.HEADER
  }
  case object AUTHORIZER extends zio.aws.apigateway.model.ApiKeySourceType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.ApiKeySourceType =
      software.amazon.awssdk.services.apigateway.model.ApiKeySourceType.AUTHORIZER
  }
}
