package zio.aws.apigateway.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigateway.model.primitives.{NullableInteger, ProviderARN}
import scala.jdk.CollectionConverters._
final case class UpdateAuthorizerResponse(
    id: Option[String] = None,
    name: Option[String] = None,
    `type`: Option[zio.aws.apigateway.model.AuthorizerType] = None,
    providerARNs: Option[Iterable[ProviderARN]] = None,
    authType: Option[String] = None,
    authorizerUri: Option[String] = None,
    authorizerCredentials: Option[String] = None,
    identitySource: Option[String] = None,
    identityValidationExpression: Option[String] = None,
    authorizerResultTtlInSeconds: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerResponse = {
    import UpdateAuthorizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        providerARNs.map(value =>
          value.map { item =>
            ProviderARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.providerARNs)
      .optionallyWith(authType.map(value => value: java.lang.String))(
        _.authType
      )
      .optionallyWith(authorizerUri.map(value => value: java.lang.String))(
        _.authorizerUri
      )
      .optionallyWith(
        authorizerCredentials.map(value => value: java.lang.String)
      )(_.authorizerCredentials)
      .optionallyWith(identitySource.map(value => value: java.lang.String))(
        _.identitySource
      )
      .optionallyWith(
        identityValidationExpression.map(value => value: java.lang.String)
      )(_.identityValidationExpression)
      .optionallyWith(
        authorizerResultTtlInSeconds.map(value =>
          NullableInteger.unwrap(value): Integer
        )
      )(_.authorizerResultTtlInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateAuthorizerResponse.ReadOnly =
    zio.aws.apigateway.model.UpdateAuthorizerResponse.wrap(buildAwsValue())
}
object UpdateAuthorizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateAuthorizerResponse =
      zio.aws.apigateway.model.UpdateAuthorizerResponse(
        id.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        providerARNs.map(value => value),
        authType.map(value => value),
        authorizerUri.map(value => value),
        authorizerCredentials.map(value => value),
        identitySource.map(value => value),
        identityValidationExpression.map(value => value),
        authorizerResultTtlInSeconds.map(value => value)
      )
    def id: Option[String]
    def name: Option[String]
    def `type`: Option[zio.aws.apigateway.model.AuthorizerType]
    def providerARNs: Option[List[ProviderARN]]
    def authType: Option[String]
    def authorizerUri: Option[String]
    def authorizerCredentials: Option[String]
    def identitySource: Option[String]
    def identityValidationExpression: Option[String]
    def authorizerResultTtlInSeconds: Option[NullableInteger]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.apigateway.model.AuthorizerType] =
      AwsError.unwrapOptionField("type", `type`)
    def getProviderARNs: ZIO[Any, AwsError, List[ProviderARN]] =
      AwsError.unwrapOptionField("providerARNs", providerARNs)
    def getAuthType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authType", authType)
    def getAuthorizerUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizerUri", authorizerUri)
    def getAuthorizerCredentials: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizerCredentials", authorizerCredentials)
    def getIdentitySource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("identitySource", identitySource)
    def getIdentityValidationExpression: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "identityValidationExpression",
        identityValidationExpression
      )
    def getAuthorizerResultTtlInSeconds: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "authorizerResultTtlInSeconds",
        authorizerResultTtlInSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerResponse
  ) extends zio.aws.apigateway.model.UpdateAuthorizerResponse.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val `type`: Option[zio.aws.apigateway.model.AuthorizerType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.apigateway.model.AuthorizerType.wrap(value))
    override val providerARNs: Option[List[ProviderARN]] = scala
      .Option(impl.providerARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.primitives.ProviderARN(item)
        }.toList
      )
    override val authType: Option[String] =
      scala.Option(impl.authType()).map(value => value: String)
    override val authorizerUri: Option[String] =
      scala.Option(impl.authorizerUri()).map(value => value: String)
    override val authorizerCredentials: Option[String] =
      scala.Option(impl.authorizerCredentials()).map(value => value: String)
    override val identitySource: Option[String] =
      scala.Option(impl.identitySource()).map(value => value: String)
    override val identityValidationExpression: Option[String] = scala
      .Option(impl.identityValidationExpression())
      .map(value => value: String)
    override val authorizerResultTtlInSeconds: Option[NullableInteger] = scala
      .Option(impl.authorizerResultTtlInSeconds())
      .map(value => zio.aws.apigateway.model.primitives.NullableInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerResponse
  ): zio.aws.apigateway.model.UpdateAuthorizerResponse.ReadOnly = new Wrapper(
    impl
  )
}
