package zio.aws.apigateway.model
import scala.jdk.CollectionConverters._
sealed trait GatewayResponseType {
  def unwrap
      : software.amazon.awssdk.services.apigateway.model.GatewayResponseType
}
object GatewayResponseType {
  def wrap(
      value: software.amazon.awssdk.services.apigateway.model.GatewayResponseType
  ): zio.aws.apigateway.model.GatewayResponseType = value match {
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.DEFAULT_4_XX =>
      val r = DEFAULT_4XX
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.DEFAULT_5_XX =>
      val r = DEFAULT_5XX
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.RESOURCE_NOT_FOUND =>
      val r = RESOURCE_NOT_FOUND
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.UNAUTHORIZED =>
      val r = UNAUTHORIZED
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.INVALID_API_KEY =>
      val r = INVALID_API_KEY
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.AUTHORIZER_FAILURE =>
      val r = AUTHORIZER_FAILURE
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.AUTHORIZER_CONFIGURATION_ERROR =>
      val r = AUTHORIZER_CONFIGURATION_ERROR
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.INVALID_SIGNATURE =>
      val r = INVALID_SIGNATURE
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.EXPIRED_TOKEN =>
      val r = EXPIRED_TOKEN
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.MISSING_AUTHENTICATION_TOKEN =>
      val r = MISSING_AUTHENTICATION_TOKEN
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.INTEGRATION_FAILURE =>
      val r = INTEGRATION_FAILURE
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.INTEGRATION_TIMEOUT =>
      val r = INTEGRATION_TIMEOUT
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.API_CONFIGURATION_ERROR =>
      val r = API_CONFIGURATION_ERROR
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.UNSUPPORTED_MEDIA_TYPE =>
      val r = UNSUPPORTED_MEDIA_TYPE
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.BAD_REQUEST_PARAMETERS =>
      val r = BAD_REQUEST_PARAMETERS
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.BAD_REQUEST_BODY =>
      val r = BAD_REQUEST_BODY
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.REQUEST_TOO_LARGE =>
      val r = REQUEST_TOO_LARGE
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.THROTTLED =>
      val r = THROTTLED
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.QUOTA_EXCEEDED =>
      val r = QUOTA_EXCEEDED
      r
    case software.amazon.awssdk.services.apigateway.model.GatewayResponseType.WAF_FILTERED =>
      val r = WAF_FILTERED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT_4XX extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.DEFAULT_4_XX
  }
  case object DEFAULT_5XX extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.DEFAULT_5_XX
  }
  case object RESOURCE_NOT_FOUND
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.RESOURCE_NOT_FOUND
  }
  case object UNAUTHORIZED
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.UNAUTHORIZED
  }
  case object INVALID_API_KEY
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.INVALID_API_KEY
  }
  case object ACCESS_DENIED
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.ACCESS_DENIED
  }
  case object AUTHORIZER_FAILURE
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.AUTHORIZER_FAILURE
  }
  case object AUTHORIZER_CONFIGURATION_ERROR
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.AUTHORIZER_CONFIGURATION_ERROR
  }
  case object INVALID_SIGNATURE
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.INVALID_SIGNATURE
  }
  case object EXPIRED_TOKEN
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.EXPIRED_TOKEN
  }
  case object MISSING_AUTHENTICATION_TOKEN
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.MISSING_AUTHENTICATION_TOKEN
  }
  case object INTEGRATION_FAILURE
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.INTEGRATION_FAILURE
  }
  case object INTEGRATION_TIMEOUT
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.INTEGRATION_TIMEOUT
  }
  case object API_CONFIGURATION_ERROR
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.API_CONFIGURATION_ERROR
  }
  case object UNSUPPORTED_MEDIA_TYPE
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.UNSUPPORTED_MEDIA_TYPE
  }
  case object BAD_REQUEST_PARAMETERS
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.BAD_REQUEST_PARAMETERS
  }
  case object BAD_REQUEST_BODY
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.BAD_REQUEST_BODY
  }
  case object REQUEST_TOO_LARGE
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.REQUEST_TOO_LARGE
  }
  case object THROTTLED extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.THROTTLED
  }
  case object QUOTA_EXCEEDED
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.QUOTA_EXCEEDED
  }
  case object WAF_FILTERED
      extends zio.aws.apigateway.model.GatewayResponseType {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.GatewayResponseType =
      software.amazon.awssdk.services.apigateway.model.GatewayResponseType.WAF_FILTERED
  }
}
