package zio.aws.amplifyuibuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CodegenGenericDataField(
    dataType: zio.aws.amplifyuibuilder.model.CodegenGenericDataFieldDataType,
    dataTypeValue: String,
    required: Boolean,
    readOnly: Boolean,
    isArray: Boolean,
    relationship: Optional[
      zio.aws.amplifyuibuilder.model.CodegenGenericDataRelationshipType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataField = {
    import CodegenGenericDataField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataField
      .builder()
      .dataType(dataType.unwrap)
      .dataTypeValue(dataTypeValue: java.lang.String)
      .required(required: java.lang.Boolean)
      .readOnly(readOnly: java.lang.Boolean)
      .isArray(isArray: java.lang.Boolean)
      .optionallyWith(relationship.map(value => value.buildAwsValue()))(
        _.relationship
      )
      .build()
  }
  def asReadOnly
      : zio.aws.amplifyuibuilder.model.CodegenGenericDataField.ReadOnly =
    zio.aws.amplifyuibuilder.model.CodegenGenericDataField.wrap(buildAwsValue())
}
object CodegenGenericDataField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplifyuibuilder.model.CodegenGenericDataField =
      zio.aws.amplifyuibuilder.model.CodegenGenericDataField(
        dataType,
        dataTypeValue,
        required,
        readOnly,
        isArray,
        relationship.map(value => value.asEditable)
      )
    def dataType: zio.aws.amplifyuibuilder.model.CodegenGenericDataFieldDataType
    def dataTypeValue: String
    def required: Boolean
    def readOnly: Boolean
    def isArray: Boolean
    def relationship: Optional[
      zio.aws.amplifyuibuilder.model.CodegenGenericDataRelationshipType.ReadOnly
    ]
    def getDataType: ZIO[
      Any,
      Nothing,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataFieldDataType
    ] = ZIO.succeed(dataType)
    def getDataTypeValue: ZIO[Any, Nothing, String] = ZIO.succeed(dataTypeValue)
    def getRequired: ZIO[Any, Nothing, Boolean] = ZIO.succeed(required)
    def getReadOnly: ZIO[Any, Nothing, Boolean] = ZIO.succeed(readOnly)
    def getIsArray: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isArray)
    def getRelationship: ZIO[
      Any,
      AwsError,
      zio.aws.amplifyuibuilder.model.CodegenGenericDataRelationshipType.ReadOnly
    ] = AwsError.unwrapOptionField("relationship", relationship)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataField
  ) extends zio.aws.amplifyuibuilder.model.CodegenGenericDataField.ReadOnly {
    override val dataType
        : zio.aws.amplifyuibuilder.model.CodegenGenericDataFieldDataType =
      zio.aws.amplifyuibuilder.model.CodegenGenericDataFieldDataType
        .wrap(impl.dataType())
    override val dataTypeValue: String = impl.dataTypeValue(): String
    override val required: Boolean = impl.required(): Boolean
    override val readOnly: Boolean = impl.readOnly(): Boolean
    override val isArray: Boolean = impl.isArray(): Boolean
    override val relationship: Optional[
      zio.aws.amplifyuibuilder.model.CodegenGenericDataRelationshipType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.relationship())
      .map(value =>
        zio.aws.amplifyuibuilder.model.CodegenGenericDataRelationshipType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplifyuibuilder.model.CodegenGenericDataField
  ): zio.aws.amplifyuibuilder.model.CodegenGenericDataField.ReadOnly =
    new Wrapper(impl)
}
